/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.messaging.router;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.util.oldies.LoggingUtil;
import org.petalslink.dsb.kernel.messaging.router.ReceiverModule;
import org.petalslink.dsb.kernel.messaging.router.RouterModuleManager;
import org.petalslink.dsb.kernel.messaging.router.SenderModule;
import org.petalslink.dsb.ws.api.RouterModule;
import org.petalslink.dsb.ws.api.RouterModuleService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=RouterModuleService.class)})
public class RouterModuleServiceImpl
implements BindingController,
LifeCycleController,
RouterModuleService {
    private Logger logger;
    private LoggingUtil log;
    @Requires(name="router-module-manager", signature=RouterModuleManager.class)
    protected RouterModuleManager routerModuleManager;
    private LoggerFactory loggerFactory;

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
    }

    public List<RouterModule> getSenders() {
        List<SenderModule> list = this.routerModuleManager.getSenders();
        ArrayList<RouterModule> arrayList = new ArrayList<RouterModule>();
        if (list != null) {
            for (SenderModule senderModule : list) {
                RouterModule routerModule = new RouterModule();
                routerModule.setDescription(senderModule.getDescription());
                routerModule.setName(senderModule.getName());
                routerModule.setState(this.routerModuleManager.getSenderState(senderModule.getName()));
                arrayList.add(routerModule);
            }
        }
        return arrayList;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public List<RouterModule> getReceivers() {
        List<ReceiverModule> list = this.routerModuleManager.getReceivers();
        ArrayList<RouterModule> arrayList = new ArrayList<RouterModule>();
        if (list != null) {
            for (ReceiverModule receiverModule : list) {
                RouterModule routerModule = new RouterModule();
                routerModule.setDescription(receiverModule.getDescription());
                routerModule.setName(receiverModule.getName());
                routerModule.setState(this.routerModuleManager.getReceiverState(receiverModule.getName()));
                arrayList.add(routerModule);
            }
        }
        return arrayList;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void setSenderState(String string, boolean bl) {
        this.routerModuleManager.setSenderState(string, bl);
    }

    public void setReceiverState(String string, boolean bl) {
        this.routerModuleManager.setReceiverState(string, bl);
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("router-module-manager")) {
            if (!RouterModuleManager.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + RouterModuleManager.class.getName());
            }
            this.routerModuleManager = (RouterModuleManager)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("router-module-manager");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("router-module-manager")) {
            return this.routerModuleManager;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("router-module-manager")) {
            this.routerModuleManager = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

