/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.messaging.router;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.xml.namespace.QName;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.Cardinality;
import org.objectweb.fractal.fraclet.annotation.annotations.type.Contingency;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.container.lifecycle.ServiceUnitLifeCycle;
import org.ow2.petals.jbi.component.context.ComponentContext;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.exchange.MessageExchangeWrapper;
import org.ow2.petals.jbi.messaging.routing.RouterService;
import org.ow2.petals.jbi.messaging.routing.RoutingException;
import org.ow2.petals.jbi.messaging.routing.module.InstallModule;
import org.ow2.petals.jbi.messaging.routing.monitoring.RouterMonitorService;
import org.ow2.petals.jbi.messaging.routing.util.SourcesForkerUtil;
import org.ow2.petals.transport.TransportException;
import org.ow2.petals.transport.TransportListener;
import org.ow2.petals.transport.Transporter;
import org.ow2.petals.transport.util.TransportSendContext;
import org.ow2.petals.util.oldies.LoggingUtil;
import org.petalslink.dsb.annotations.LifeCycleListener;
import org.petalslink.dsb.annotations.Phase;
import org.petalslink.dsb.kernel.messaging.router.ReceiverModule;
import org.petalslink.dsb.kernel.messaging.router.RouterModuleManager;
import org.petalslink.dsb.kernel.messaging.router.RouterModuleManagerImpl;
import org.petalslink.dsb.kernel.messaging.router.SenderModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=RouterService.class), @Interface(name="transportlistener", signature=TransportListener.class), @Interface(name="routermodulemanager", signature=RouterModuleManager.class)})
public class RouterServiceImpl
implements BindingController,
LifeCycleController,
RouterService,
TransportListener,
RouterModuleManager {
    private LoggerFactory loggerFactory;
    private LoggingUtil log;
    private Logger logger;
    private RouterModuleManager routerModuleManager;
    private static final String INSTALLMODULE_FRACTAL_PREFIX = "installmodule";
    private static final String PROVIDER_SUFFIX = "-provider";
    private static final int QUEUE_SIZE = 10000;
    private static final String RECEIVERMODULE_FRACTAL_PREFIX = "receivermodule";
    private static final String SENDERMODULE_FRACTAL_PREFIX = "sendermodule";
    private static final int STOP_TRAFFIC_TIMEOUT = 10000;
    private static final String TRANSPORTER_FRACTAL_PREFIX = "transporter";
    private Map<String, BlockingQueue<MessageExchangeWrapper>> exchangeQueues;
    @Requires(contingency=Contingency.OPTIONAL, name="routermonitor", signature=RouterMonitorService.class)
    private RouterMonitorService routerMonitorService;
    @Requires(cardinality=Cardinality.COLLECTION, contingency=Contingency.OPTIONAL, name="installmodule", signature=InstallModule.class)
    private final Map<String, Object> installModules = new Hashtable<String, Object>();
    private Map<String, List<MessageExchangeWrapper>> pendingMessageExchanges;
    @Requires(cardinality=Cardinality.COLLECTION, contingency=Contingency.OPTIONAL, name="receivermodule", signature=org.ow2.petals.jbi.messaging.routing.module.ReceiverModule.class)
    private final Map<String, Object> receiverModules = new Hashtable<String, Object>();
    @Requires(cardinality=Cardinality.COLLECTION, contingency=Contingency.OPTIONAL, name="sendermodule", signature=org.ow2.petals.jbi.messaging.routing.module.SenderModule.class)
    private final Map<String, Object> senderModules = new Hashtable<String, Object>();
    private boolean stopTraffic;
    private List<Thread> threadsList;
    @Requires(cardinality=Cardinality.COLLECTION, contingency=Contingency.OPTIONAL, name="transporter", signature=Transporter.class)
    private final Map<String, Object> transporters = new Hashtable<String, Object>();

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    private static final boolean checkBypassMessageExchange(MessageExchangeWrapper messageExchangeWrapper) {
        boolean bl = false;
        Object object = null;
        if (messageExchangeWrapper.isTerminated()) {
            object = MessageExchange.Role.CONSUMER.equals(messageExchangeWrapper.getRole()) ? messageExchangeWrapper.getProperty("org.ow2.petals.router.provider.noack") : messageExchangeWrapper.getProperty("org.ow2.petals.router.consumer.noack");
            bl = object != null && object.toString().toLowerCase().equals("true");
        }
        return bl;
    }

    public void addComponent(ComponentContext componentContext) throws RoutingException {
        this.log.start();
        for (Object object : this.installModules.values()) {
            ((InstallModule)object).addComponent(componentContext);
        }
        this.exchangeQueues.put(componentContext.getComponentName(), new ArrayBlockingQueue(10000));
        this.log.end();
    }

    public void exchangeSent(MessageExchangeWrapper messageExchangeWrapper) {
        if (this.routerMonitorService != null) {
            this.routerMonitorService.exchangeSent(messageExchangeWrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifiedSALifeCycle(List<ServiceUnitLifeCycle> list) {
        this.log.start();
        Map<String, List<MessageExchangeWrapper>> map = this.pendingMessageExchanges;
        synchronized (map) {
            for (ServiceUnitLifeCycle serviceUnitLifeCycle : list) {
                List list2 = serviceUnitLifeCycle.getServiceUnitDescriptor().getServices().getProvides();
                if (list2 == null) continue;
                String string = serviceUnitLifeCycle.getCurrentState();
                for (org.ow2.petals.jbi.descriptor.original.generated.Provides provides : list2) {
                    String string2 = String.valueOf(provides.getEndpointName()) + provides.getServiceName() + PROVIDER_SUFFIX;
                    if ("Stopped".equals(string) || "Shutdown".equals(string)) {
                        if (this.pendingMessageExchanges.containsKey(string2)) continue;
                        this.pendingMessageExchanges.put(string2, new Vector(100));
                        continue;
                    }
                    if (!"Started".equals(string)) continue;
                    BlockingQueue<MessageExchangeWrapper> blockingQueue = this.exchangeQueues.get(serviceUnitLifeCycle.getTargetComponentName());
                    blockingQueue.addAll((Collection<MessageExchangeWrapper>)this.pendingMessageExchanges.remove(string2));
                }
            }
        }
        this.log.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onExchange(MessageExchangeWrapper messageExchangeWrapper) {
        this.log.start();
        String string = null;
        if (this.routerMonitorService != null) {
            this.routerMonitorService.exchangeReceived(messageExchangeWrapper);
        }
        Map<String, List<MessageExchangeWrapper>> map = this.pendingMessageExchanges;
        synchronized (map) {
            if (messageExchangeWrapper.getRole().equals(MessageExchange.Role.CONSUMER)) {
                string = ((ServiceEndpoint)messageExchangeWrapper.getConsumerEndpoint()).getLocation().getComponentName();
            } else if (messageExchangeWrapper.getRole().equals(MessageExchange.Role.PROVIDER)) {
                ServiceEndpoint serviceEndpoint = (ServiceEndpoint)messageExchangeWrapper.getEndpoint();
                String string2 = String.valueOf(serviceEndpoint.getEndpointName()) + serviceEndpoint.getServiceName() + PROVIDER_SUFFIX;
                if (this.pendingMessageExchanges.containsKey(string2)) {
                    this.log.debug((Object)"SU not started, store the exchange");
                    this.pendingMessageExchanges.get(string2).add(messageExchangeWrapper);
                } else {
                    string = ((ServiceEndpoint)messageExchangeWrapper.getEndpoint()).getLocation().getComponentName();
                }
            }
        }
        if (string != null) {
            this.exchangeQueues.get(string).add(messageExchangeWrapper);
        }
        this.log.end();
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("routermonitor")) {
            if (!RouterMonitorService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + RouterMonitorService.class.getName());
            }
            this.routerMonitorService = (RouterMonitorService)object;
            return;
        }
        if (string.startsWith(INSTALLMODULE_FRACTAL_PREFIX)) {
            if (!InstallModule.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + InstallModule.class.getName());
            }
            this.installModules.put(string, object);
            return;
        }
        if (string.startsWith(RECEIVERMODULE_FRACTAL_PREFIX)) {
            if (!org.ow2.petals.jbi.messaging.routing.module.ReceiverModule.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + org.ow2.petals.jbi.messaging.routing.module.ReceiverModule.class.getName());
            }
            this.receiverModules.put(string, object);
            return;
        }
        if (string.startsWith(SENDERMODULE_FRACTAL_PREFIX)) {
            if (!org.ow2.petals.jbi.messaging.routing.module.SenderModule.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + org.ow2.petals.jbi.messaging.routing.module.SenderModule.class.getName());
            }
            this.senderModules.put(string, object);
            return;
        }
        if (string.startsWith(TRANSPORTER_FRACTAL_PREFIX)) {
            if (!Transporter.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + Transporter.class.getName());
            }
            this.transporters.put(string, object);
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("routermonitor");
        arrayList.addAll((Collection)this.installModules.keySet());
        arrayList.addAll((Collection)this.receiverModules.keySet());
        arrayList.addAll((Collection)this.senderModules.keySet());
        arrayList.addAll((Collection)this.transporters.keySet());
        return arrayList.toArray(new String[0]);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MessageExchangeWrapper receive(ComponentContext componentContext, long l) throws RoutingException {
        Iterator<ReceiverModule> iterator;
        MessageExchangeWrapper messageExchangeWrapper;
        String string;
        block10: {
            block9: {
                string = componentContext.getComponentName();
                this.log.start((Object)("Component : " + string + " - Timeout : " + l));
                this.checkStopTraffic();
                if (l != 0L) break block9;
                messageExchangeWrapper = (MessageExchangeWrapper)this.exchangeQueues.get(string).poll();
                break block10;
            }
            this.threadsList.add(Thread.currentThread());
            try {
                try {
                    messageExchangeWrapper = l > 0L ? this.exchangeQueues.get(string).poll(l, TimeUnit.MILLISECONDS) : this.exchangeQueues.get(string).take();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    throw new RoutingException("The pending receipt for the component '" + string + "' is interrupted", (Throwable)interruptedException);
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.threadsList.remove(Thread.currentThread());
                throw throwable;
            }
            {
                iterator = null;
                this.threadsList.remove(Thread.currentThread());
            }
        }
        if (messageExchangeWrapper == null) {
            this.log.end((Object)("No exchange - Component : " + string));
            return messageExchangeWrapper;
        }
        iterator = this.routerModuleManager.getReceivers().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.log.end((Object)("Exchange Id : " + messageExchangeWrapper.getExchangeId() + " - Component : " + string));
                return messageExchangeWrapper;
            }
            ReceiverModule receiverModule = iterator.next();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("Receiver module %s is called", receiverModule.getName()));
            }
            receiverModule.receiveExchange(messageExchangeWrapper, componentContext);
        }
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("routermonitor")) {
            return this.routerMonitorService;
        }
        if (string.startsWith(string)) {
            return this.installModules.get(string);
        }
        if (string.startsWith(string)) {
            return this.receiverModules.get(string);
        }
        if (string.startsWith(string)) {
            return this.senderModules.get(string);
        }
        if (string.startsWith(string)) {
            return this.transporters.get(string);
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("routermonitor")) {
            this.routerMonitorService = null;
            return;
        }
        if (this.installModules.containsKey(string)) {
            this.installModules.remove(string);
            return;
        }
        if (this.receiverModules.containsKey(string)) {
            this.receiverModules.remove(string);
            return;
        }
        if (this.senderModules.containsKey(string)) {
            this.senderModules.remove(string);
            return;
        }
        if (this.transporters.containsKey(string)) {
            this.transporters.remove(string);
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void removeComponent(ComponentContext componentContext) throws RoutingException {
        this.log.start();
        for (Object object : this.installModules.values()) {
            ((InstallModule)object).removeComponent(componentContext);
        }
        this.exchangeQueues.remove(componentContext.getComponentName());
        this.log.end();
    }

    public void send(ComponentContext componentContext, MessageExchangeWrapper messageExchangeWrapper) throws RoutingException {
        this.log.call();
        this.checkStopTraffic();
        if (!RouterServiceImpl.checkBypassMessageExchange(messageExchangeWrapper)) {
            messageExchangeWrapper.getMessageExchange().cleanMessages();
            LinkedHashMap<ServiceEndpoint, TransportSendContext> linkedHashMap = new LinkedHashMap<ServiceEndpoint, TransportSendContext>();
            for (SenderModule senderModule : this.routerModuleManager.getSenders()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("Sender module %s is called", senderModule.getName()));
                }
                senderModule.electEndpoints(linkedHashMap, componentContext, messageExchangeWrapper);
            }
            boolean bl = false;
            try {
                messageExchangeWrapper.setObserverRole(null);
                if (MessageExchange.Role.CONSUMER.equals(messageExchangeWrapper.getRole())) {
                    messageExchangeWrapper.setRole(MessageExchange.Role.PROVIDER);
                    bl = this.sendToProvider(linkedHashMap, componentContext, messageExchangeWrapper, false, 0L);
                } else {
                    messageExchangeWrapper.setRole(MessageExchange.Role.CONSUMER);
                    TransportSendContext transportSendContext = (TransportSendContext)linkedHashMap.values().iterator().next();
                    bl = this.sendToConsumer(transportSendContext, messageExchangeWrapper, false, 0L);
                }
                if (!bl) {
                    messageExchangeWrapper.setObserverRole(messageExchangeWrapper.getRole());
                }
            }
            catch (RoutingException routingException) {
                if (MessageExchange.Role.CONSUMER.equals(messageExchangeWrapper.getRole())) {
                    messageExchangeWrapper.setRole(MessageExchange.Role.PROVIDER);
                    messageExchangeWrapper.setObserverRole(MessageExchange.Role.PROVIDER);
                } else {
                    messageExchangeWrapper.setRole(MessageExchange.Role.CONSUMER);
                    messageExchangeWrapper.setObserverRole(MessageExchange.Role.CONSUMER);
                }
                throw routingException;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendSync(ComponentContext componentContext, MessageExchangeWrapper messageExchangeWrapper, long l) throws RoutingException {
        this.log.call();
        this.checkStopTraffic();
        messageExchangeWrapper.getMessageExchange().cleanMessages();
        this.removeBypassMessageExchange(messageExchangeWrapper);
        long l2 = 0L;
        if (l > 0L) {
            l2 = System.currentTimeMillis();
            messageExchangeWrapper.setProperty("org.ow2.petals.router.timetolive", (Object)(l2 + l));
        }
        LinkedHashMap<ServiceEndpoint, TransportSendContext> linkedHashMap = new LinkedHashMap<ServiceEndpoint, TransportSendContext>();
        for (SenderModule senderModule : this.routerModuleManager.getSenders()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("Sender module %s is called", senderModule.getName()));
            }
            senderModule.electEndpoints(linkedHashMap, componentContext, messageExchangeWrapper);
        }
        long l3 = l;
        if (l3 > 0L && (l3 -= System.currentTimeMillis() - l2) == 0L) {
            l3 = -1L;
        }
        if (l3 < 0L) {
            messageExchangeWrapper.setTimeout(true);
            return;
        }
        MessageExchange.Role role = messageExchangeWrapper.getRole();
        try {
            messageExchangeWrapper.setObserverRole(null);
            if (MessageExchange.Role.CONSUMER.equals(messageExchangeWrapper.getRole())) {
                messageExchangeWrapper.setRole(MessageExchange.Role.PROVIDER);
                this.sendToProvider(linkedHashMap, componentContext, messageExchangeWrapper, true, l);
            } else {
                messageExchangeWrapper.setRole(MessageExchange.Role.CONSUMER);
                Object object = (TransportSendContext)linkedHashMap.values().iterator().next();
                this.sendToConsumer((TransportSendContext)object, messageExchangeWrapper, true, l);
            }
            if (!messageExchangeWrapper.isTimeout()) {
                if (this.routerMonitorService != null) {
                    this.routerMonitorService.exchangeReceived(messageExchangeWrapper);
                }
                for (Object object : this.routerModuleManager.getReceivers()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)String.format("Receiver module %s is called", object.getName()));
                    }
                    object.receiveExchange(messageExchangeWrapper, componentContext);
                }
            }
            Object var13_14 = null;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            messageExchangeWrapper.setRole(role);
            messageExchangeWrapper.setObserverRole(role);
            throw throwable;
        }
        messageExchangeWrapper.setRole(role);
        messageExchangeWrapper.setObserverRole(role);
    }

    public void stopTraffic() {
        this.log.start();
        long l = 10000L + System.currentTimeMillis();
        boolean bl = false;
        try {
            while (System.currentTimeMillis() < l && !bl) {
                for (BlockingQueue<MessageExchangeWrapper> blockingQueue : this.exchangeQueues.values()) {
                    if (blockingQueue.size() <= 0) continue;
                    Thread.sleep(1000L);
                    break;
                }
                bl = true;
            }
        }
        catch (InterruptedException interruptedException) {}
        if (!bl) {
            this.log.warning((Object)"The timeout for stopping the Router traffic has been reached. Some message have not beed accepted by the component, they are lost.");
        }
        this.stopTraffic = true;
        boolean bl2 = true;
        while (bl2) {
            try {
                for (Thread thread : this.threadsList) {
                    if (!thread.isAlive()) continue;
                    thread.interrupt();
                }
                bl2 = false;
            }
            catch (ConcurrentModificationException concurrentModificationException) {}
        }
        this.log.end();
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() throws RoutingException {
        this.log = new LoggingUtil(this.logger);
        this.routerModuleManager = new RouterModuleManagerImpl();
        this.log.call();
        this.exchangeQueues = new ConcurrentHashMap<String, BlockingQueue<MessageExchangeWrapper>>();
        this.pendingMessageExchanges = new ConcurrentHashMap<String, List<MessageExchangeWrapper>>();
        this.threadsList = new Vector<Thread>(100);
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() throws RoutingException {
        this.log.call();
    }

    private void checkStopTraffic() throws RoutingException {
        if (this.stopTraffic) {
            Thread.currentThread().interrupt();
            throw new RoutingException("The Router traffic is stopped", (Throwable)new InterruptedException());
        }
    }

    private boolean removeBypassMessageExchange(MessageExchangeWrapper messageExchangeWrapper) {
        this.log.call();
        if (messageExchangeWrapper.isTerminated()) {
            if (MessageExchange.Role.CONSUMER.equals(messageExchangeWrapper.getRole())) {
                if (messageExchangeWrapper.getProperty("org.ow2.petals.router.consumer.noack") != null) {
                    messageExchangeWrapper.setProperty("org.ow2.petals.router.consumer.noack", (Object)"false");
                    this.log.warning((Object)"Property 'org.ow2.petals.router.consumer.noack' is not supported in synchronous send mode");
                }
            } else if (messageExchangeWrapper.getProperty("org.ow2.petals.router.provider.noack") != null) {
                messageExchangeWrapper.setProperty("org.ow2.petals.router.provider.noack", (Object)"false");
                this.log.warning((Object)"Property 'org.ow2.petals.router.provider.noack' is not supported in synchronous send mode");
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean sendToConsumer(TransportSendContext transportSendContext, MessageExchangeWrapper messageExchangeWrapper, boolean bl, long l) throws RoutingException {
        this.log.start();
        boolean bl2 = false;
        long l2 = System.currentTimeMillis();
        boolean bl3 = true;
        int n = 0;
        while (bl3) {
            Object var13_13;
            bl3 = false;
            if (n != 0) {
                try {
                    Thread.sleep(transportSendContext.delay);
                }
                catch (InterruptedException interruptedException) {
                    throw new RoutingException((Throwable)interruptedException);
                }
            }
            try {
                try {
                    if (transportSendContext.attempt > 1 || messageExchangeWrapper.getMessageExchange().isPersisted()) {
                        try {
                            SourcesForkerUtil.forkExchangeSources((MessageExchangeWrapper)messageExchangeWrapper);
                        }
                        catch (MessagingException messagingException) {
                            throw new RoutingException((Throwable)messagingException);
                        }
                    }
                    if (bl) {
                        if (l > 0L) {
                            long l3 = System.currentTimeMillis() - l2;
                            if (l3 > l) {
                                messageExchangeWrapper.setTimeout(true);
                                var13_13 = null;
                                try {
                                    SourcesForkerUtil.cleanExchangeSources((MessageExchange)messageExchangeWrapper);
                                }
                                catch (IOException iOException) {}
                                break;
                            }
                            transportSendContext.timeout = l - l3;
                        }
                        ((Transporter)this.transporters.get("transporter-" + transportSendContext.transport)).sendSync(messageExchangeWrapper, transportSendContext);
                    } else {
                        ((Transporter)this.transporters.get("transporter-" + transportSendContext.transport)).send(messageExchangeWrapper, transportSendContext);
                        if ("local".equals(transportSendContext.transport)) {
                            bl2 = true;
                        }
                    }
                    bl3 = false;
                }
                catch (TransportException transportException) {
                    transportSendContext.attempt = (short)(transportSendContext.attempt - 1);
                    if (transportSendContext.attempt <= 0) throw new RoutingException((Throwable)transportException);
                    this.log.warning((Object)("The send attempt to the " + transportSendContext.destination + " failed"), (Throwable)transportException);
                    bl3 = true;
                    n = transportSendContext.delay;
                }
                var13_13 = null;
            }
            catch (Throwable throwable) {
                var13_13 = null;
                try {}
                catch (IOException iOException) {}
                SourcesForkerUtil.cleanExchangeSources((MessageExchange)messageExchangeWrapper);
                throw throwable;
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            SourcesForkerUtil.cleanExchangeSources((MessageExchange)messageExchangeWrapper);
        }
        this.log.end();
        return bl2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean sendToProvider(Map<ServiceEndpoint, TransportSendContext> map, ComponentContext componentContext, MessageExchangeWrapper messageExchangeWrapper, boolean bl, long l) throws RoutingException {
        this.log.start();
        boolean bl2 = false;
        TransportSendContext transportSendContext = null;
        long l2 = System.currentTimeMillis();
        boolean bl3 = true;
        int n = 0;
        while (true) {
            Object var17_17;
            if (!bl3) {
                this.log.end();
                return bl2;
            }
            if (n != 0) {
                this.log.debug((Object)("Wait " + n + " millisecond before the next send attempt"));
                try {
                    Thread.sleep(n);
                }
                catch (InterruptedException interruptedException) {
                    throw new RoutingException((Throwable)interruptedException);
                }
            }
            bl3 = false;
            Iterator<ServiceEndpoint> iterator = map.keySet().iterator();
            try {
                while (iterator.hasNext()) {
                    ServiceEndpoint serviceEndpoint = iterator.next();
                    transportSendContext = map.get(serviceEndpoint);
                    if (transportSendContext.attempt <= 0) continue;
                    this.log.debug((Object)("Send attempt to endpoint '" + serviceEndpoint.getEndpointName() + "'"));
                    try {
                        block24: {
                            block21: {
                                block22: {
                                    long l3;
                                    block23: {
                                        messageExchangeWrapper.setEndpoint((javax.jbi.servicedesc.ServiceEndpoint)serviceEndpoint);
                                        messageExchangeWrapper.setService(serviceEndpoint.getServiceName());
                                        messageExchangeWrapper.setInterfaceName((QName)serviceEndpoint.getInterfacesName().get(0));
                                        if (iterator.hasNext() || n > 0 || transportSendContext.attempt > 1 || messageExchangeWrapper.getMessageExchange().isPersisted()) {
                                            try {
                                                SourcesForkerUtil.forkExchangeSources((MessageExchangeWrapper)messageExchangeWrapper);
                                            }
                                            catch (MessagingException messagingException) {
                                                throw new RoutingException((Throwable)messagingException);
                                            }
                                        }
                                        if (!bl) break block21;
                                        if (l <= 0L) break block22;
                                        l3 = System.currentTimeMillis() - l2;
                                        if (l3 <= l) break block23;
                                        this.log.debug((Object)"Timeout reached!");
                                        messageExchangeWrapper.setTimeout(true);
                                        bl3 = false;
                                        break;
                                    }
                                    transportSendContext.timeout = l - l3;
                                }
                                ((Transporter)this.transporters.get("transporter-" + transportSendContext.transport)).sendSync(messageExchangeWrapper, transportSendContext);
                                break block24;
                            }
                            ((Transporter)this.transporters.get("transporter-" + transportSendContext.transport)).send(messageExchangeWrapper, transportSendContext);
                            if ("local".equals(transportSendContext.transport)) {
                                bl2 = true;
                            }
                        }
                        bl3 = false;
                        break;
                    }
                    catch (TransportException transportException) {
                        transportSendContext.attempt = (short)(transportSendContext.attempt - 1);
                        if (transportSendContext.attempt > 0) {
                            bl3 = true;
                            if (transportSendContext.delay > n) {
                                n = transportSendContext.delay;
                            }
                        }
                        if (!iterator.hasNext()) {
                            if (!bl3) throw new RoutingException((Throwable)transportException);
                        }
                        this.log.warning((Object)("The send attempt to the endpoint '" + serviceEndpoint.getEndpointName() + "' with destination " + transportSendContext.destination + " failed"), (Throwable)transportException);
                    }
                }
            }
            catch (Throwable throwable) {
                var17_17 = null;
                try {
                    SourcesForkerUtil.cleanExchangeSources((MessageExchange)messageExchangeWrapper);
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                var17_17 = null;
            }
            try {}
            catch (IOException iOException) {}
            SourcesForkerUtil.cleanExchangeSources((MessageExchange)messageExchangeWrapper);
        }
    }

    @LifeCycleListener(phase=Phase.START)
    public void loadModules() {
        Object object;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Ack to add modules to manager");
        }
        for (String string : this.senderModules.keySet()) {
            object = this.senderModules.get(string);
            if (object instanceof Component) {
                System.out.println("############## COMPONENT = " + object);
            }
            if (object == null || !(object instanceof org.ow2.petals.jbi.messaging.routing.module.SenderModule)) continue;
            this.addModule(string, (org.ow2.petals.jbi.messaging.routing.module.SenderModule)object);
        }
        for (String string : this.receiverModules.keySet()) {
            object = this.receiverModules.get(string);
            if (object == null || !(object instanceof org.ow2.petals.jbi.messaging.routing.module.ReceiverModule)) continue;
            this.addModule(string, (org.ow2.petals.jbi.messaging.routing.module.ReceiverModule)object);
        }
    }

    void addModule(final String string, final org.ow2.petals.jbi.messaging.routing.module.SenderModule senderModule) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("Adding sender module %s to manager", string));
        }
        this.routerModuleManager.add(new SenderModule(){

            public void electEndpoints(Map<ServiceEndpoint, TransportSendContext> map, ComponentContext componentContext, MessageExchangeWrapper messageExchangeWrapper) throws RoutingException {
                senderModule.electEndpoints(map, componentContext, messageExchangeWrapper);
            }

            @Override
            public String getName() {
                return string;
            }

            @Override
            public String getDescription() {
                return senderModule.getClass().getName();
            }
        });
    }

    void addModule(final String string, final org.ow2.petals.jbi.messaging.routing.module.ReceiverModule receiverModule) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("Adding receiver module %s to manager", string));
        }
        this.routerModuleManager.add(new ReceiverModule(){

            public boolean receiveExchange(MessageExchangeWrapper messageExchangeWrapper, ComponentContext componentContext) throws RoutingException {
                return receiverModule.receiveExchange(messageExchangeWrapper, componentContext);
            }

            public String getName() {
                return string;
            }

            public String getDescription() {
                return receiverModule.getClass().getName();
            }
        });
    }

    @Override
    public void add(SenderModule senderModule) {
        this.routerModuleManager.add(senderModule);
    }

    @Override
    public void add(ReceiverModule receiverModule) {
        this.routerModuleManager.add(receiverModule);
    }

    @Override
    public List<SenderModule> getSenders() {
        return this.routerModuleManager.getSenders();
    }

    @Override
    public List<ReceiverModule> getReceivers() {
        return this.routerModuleManager.getReceivers();
    }

    @Override
    public void setSenderState(String string, boolean bl) {
        this.routerModuleManager.setSenderState(string, bl);
    }

    @Override
    public void setReceiverState(String string, boolean bl) {
        this.routerModuleManager.setReceiverState(string, bl);
    }

    @Override
    public boolean getReceiverState(String string) {
        return this.routerModuleManager.getReceiverState(string);
    }

    @Override
    public boolean getSenderState(String string) {
        return this.routerModuleManager.getSenderState(string);
    }
}

