/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.messaging.router.modules;

import java.util.ArrayList;
import java.util.Map;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.jbi.component.context.ComponentContext;
import org.ow2.petals.jbi.messaging.control.ExchangeCheckerClient;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.exchange.MessageExchangeWrapper;
import org.ow2.petals.jbi.messaging.routing.RoutingException;
import org.ow2.petals.jbi.messaging.routing.module.SenderModule;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.transport.util.TransportSendContext;
import org.ow2.petals.util.oldies.LoggingUtil;
import org.petalslink.dsb.kernel.api.messaging.EndpointSearchEngine;
import org.petalslink.dsb.kernel.messaging.router.modules.EndpointResolverModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=SenderModule.class)})
public class FractalEndpointResolverModule
implements BindingController,
LifeCycleController,
SenderModule {
    protected LoggingUtil log;
    private LoggerFactory loggerFactory;
    protected Logger logger;
    @Requires(name="configuration", signature=ConfigurationService.class)
    protected ConfigurationService configurationService;
    @Requires(name="checker", signature=ExchangeCheckerClient.class)
    protected ExchangeCheckerClient exchangeCheckerClient;
    @Requires(name="endpoint-search-engine", signature=EndpointSearchEngine.class)
    private EndpointSearchEngine endpointSearchEngine;
    private EndpointResolverModule delegate;

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() throws Exception {
        this.log = new LoggingUtil(this.logger);
        this.log.call();
        this.delegate = new EndpointResolverModule(this.log);
        this.delegate.setConfigurationService(this.configurationService);
        this.delegate.setEndpointSearchEngine(this.endpointSearchEngine);
        this.delegate.setExchangeCheckerClient(this.exchangeCheckerClient);
        this.delegate.init();
        this.delegate.setup();
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() throws RoutingException {
        this.log.call();
        try {
            this.delegate.shutdown();
        }
        catch (Exception exception) {
            throw new RoutingException((Throwable)exception);
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void electEndpoints(Map<ServiceEndpoint, TransportSendContext> map, ComponentContext componentContext, MessageExchangeWrapper messageExchangeWrapper) throws RoutingException {
        this.delegate.electEndpoints(map, componentContext, messageExchangeWrapper);
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        if (string.equals("checker")) {
            if (!ExchangeCheckerClient.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ExchangeCheckerClient.class.getName());
            }
            this.exchangeCheckerClient = (ExchangeCheckerClient)object;
            return;
        }
        if (string.equals("endpoint-search-engine")) {
            if (!EndpointSearchEngine.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + EndpointSearchEngine.class.getName());
            }
            this.endpointSearchEngine = (EndpointSearchEngine)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("configuration");
        arrayList.add("checker");
        arrayList.add("endpoint-search-engine");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        if (string.equals("checker")) {
            return this.exchangeCheckerClient;
        }
        if (string.equals("endpoint-search-engine")) {
            return this.endpointSearchEngine;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        if (string.equals("checker")) {
            this.exchangeCheckerClient = null;
            return;
        }
        if (string.equals("endpoint-search-engine")) {
            this.endpointSearchEngine = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

