/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.messaging.router.modules;

import java.util.ArrayList;
import java.util.Map;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.jbi.component.context.ComponentContext;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.exchange.MessageExchangeWrapper;
import org.ow2.petals.jbi.messaging.routing.RoutingException;
import org.ow2.petals.jbi.messaging.routing.module.SenderModule;
import org.ow2.petals.transport.util.TransportSendContext;
import org.ow2.petals.util.oldies.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=SenderModule.class)})
public class SourceSetterModule
implements BindingController,
LifeCycleController,
SenderModule {
    static final String LOCATION_COMPONENT = "consumer.location.component";
    static final String LOCATION_CONTAINER = "consumer.location.container";
    static final String LOCATION_DOMAIN = "consumer.location.domain";
    private Logger logger;
    private LoggingUtil log;
    private LoggerFactory loggerFactory;

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void electEndpoints(Map<ServiceEndpoint, TransportSendContext> map, ComponentContext componentContext, MessageExchangeWrapper messageExchangeWrapper) throws RoutingException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Setting the source component location information into the exchange");
        }
        if (messageExchangeWrapper.getConsumerEndpoint() != null && messageExchangeWrapper.getConsumerEndpoint() instanceof ServiceEndpoint) {
            ServiceEndpoint serviceEndpoint = (ServiceEndpoint)messageExchangeWrapper.getConsumerEndpoint();
            messageExchangeWrapper.setProperty(LOCATION_COMPONENT, (Object)serviceEndpoint.getLocation().getComponentName());
            messageExchangeWrapper.setProperty(LOCATION_CONTAINER, (Object)serviceEndpoint.getLocation().getContainerName());
            messageExchangeWrapper.setProperty(LOCATION_DOMAIN, (Object)serviceEndpoint.getLocation().getSubdomainName());
        }
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList arrayList = new ArrayList();
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

