/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.registry;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.petalslink.dsb.api.DSBException;
import org.petalslink.dsb.api.ServiceEndpoint;
import org.petalslink.dsb.kernel.api.messaging.RegistryListener;
import org.petalslink.dsb.kernel.api.messaging.RegistryListenerManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistryListenerManagerImpl
implements RegistryListenerManager {
    private Map<String, ManagedRegistryListener> listeners = new ConcurrentHashMap<String, ManagedRegistryListener>();

    public void setState(String string, boolean bl) {
        ManagedRegistryListener managedRegistryListener = this.listeners.get(string);
        if (managedRegistryListener == null) {
            return;
        }
        managedRegistryListener.state = bl;
    }

    public boolean getState(String string) {
        ManagedRegistryListener managedRegistryListener = this.listeners.get(string);
        if (managedRegistryListener == null) {
            return false;
        }
        return managedRegistryListener.state;
    }

    public List<RegistryListener> getList() {
        ArrayList<RegistryListener> arrayList = new ArrayList<RegistryListener>(this.listeners.size());
        for (ManagedRegistryListener managedRegistryListener : this.listeners.values()) {
            arrayList.add(managedRegistryListener);
        }
        return arrayList;
    }

    public void add(RegistryListener registryListener) throws DSBException {
        if (registryListener == null) {
            throw new DSBException("listener is null");
        }
        String string = registryListener.getName();
        if (string == null) {
            throw new DSBException("listener name null");
        }
        this.listeners.put(registryListener.getName(), new ManagedRegistryListener(registryListener));
    }

    public RegistryListener get(String string) throws DSBException {
        ManagedRegistryListener managedRegistryListener = this.listeners.get(string);
        if (managedRegistryListener == null) {
            throw new DSBException(String.format("No such listener %s", string));
        }
        return managedRegistryListener;
    }

    public RegistryListener remove(String string) throws DSBException {
        ManagedRegistryListener managedRegistryListener = this.listeners.remove(string);
        if (managedRegistryListener == null) {
            throw new DSBException("No such listener %s", new Object[]{string});
        }
        return managedRegistryListener.listener;
    }

    class ManagedRegistryListener
    implements RegistryListener {
        RegistryListener listener;
        boolean state;

        ManagedRegistryListener(RegistryListener registryListener) {
            this.listener = registryListener;
            this.state = true;
        }

        public void onRegister(ServiceEndpoint serviceEndpoint) throws DSBException {
            if (this.state) {
                this.listener.onRegister(serviceEndpoint);
            }
        }

        public void onUnregister(ServiceEndpoint serviceEndpoint) throws DSBException {
            if (this.state) {
                this.listener.onUnregister(serviceEndpoint);
            }
        }

        public String getName() {
            return this.listener.getName();
        }
    }
}

