/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.util.oldies.LoggingUtil;
import org.petalslink.dsb.annotations.LifeCycleListener;
import org.petalslink.dsb.annotations.Phase;
import org.petalslink.dsb.kernel.api.resource.Resource;
import org.petalslink.dsb.kernel.api.resource.ResourceRegistry;
import org.petalslink.dsb.kernel.api.resource.ResourceRegistryFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=ResourceRegistry.class)})
public class ResourceRegistryImpl
implements BindingController,
LifeCycleController,
ResourceRegistry {
    private Logger logger;
    private LoggingUtil log;
    private Map<String, Set<Resource>> cache;
    private LoggerFactory loggerFactory;

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.debug((Object)"Starting...");
        this.cache = new HashMap<String, Set<Resource>>();
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.debug((Object)"Stopping...");
    }

    public Logger getLogger() {
        return this.logger;
    }

    @LifeCycleListener(phase=Phase.START, priority=100000)
    public void init() {
        ResourceRegistryFactory.set((ResourceRegistry)this);
    }

    public void put(Resource ... resourceArray) {
        Resource[] resourceArray2 = resourceArray;
        int n = resourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            Resource resource = resourceArray2[n2];
            if (resource.getType() != null) {
                if (!this.cache.containsKey(resource.getType())) {
                    this.cache.put(resource.getType(), new HashSet());
                }
                this.cache.get(resource.getType()).add(resource);
            }
            ++n2;
        }
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public List<Resource> all() {
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        for (String string : this.cache.keySet()) {
            for (Resource resource : this.cache.get(string)) {
                arrayList.add(resource);
            }
        }
        return arrayList;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public List<Resource> get(String string) {
        if (string == null) {
            return new ArrayList<Resource>();
        }
        return new ArrayList<Resource>((Collection)this.cache.get(string));
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList arrayList = new ArrayList();
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

