/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.tools.cron;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.util.oldies.LoggingUtil;
import org.petalslink.dsb.annotations.LifeCycleListener;
import org.petalslink.dsb.annotations.Phase;
import org.petalslink.dsb.api.DSBException;
import org.petalslink.dsb.kernel.api.tools.cron.CronManager;
import org.petalslink.dsb.kernel.api.tools.cron.CronRegistry;
import org.petalslink.dsb.kernel.api.tools.cron.CronScanner;
import org.petalslink.dsb.kernel.api.tools.cron.Job;
import org.petalslink.dsb.ws.api.cron.CronJobBean;
import org.petalslink.dsb.ws.api.cron.CronJobService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=CronManager.class), @Interface(name="webservice", signature=CronJobService.class)})
public class CronManagerImpl
implements BindingController,
LifeCycleController,
CronManager,
CronJobService {
    private Logger logger;
    private LoggingUtil log;
    private ScheduledExecutorService scheduler;
    boolean initialized = false;
    private Map<String, ScheduledFuture<?>> jobs;
    private LoggerFactory loggerFactory;
    private boolean done = false;
    @Requires(name="cron-registry", signature=CronRegistry.class)
    protected CronRegistry registry;
    @Requires(name="cron-scanner", signature=CronScanner.class)
    protected CronScanner scanner;

    public Logger getLogger() {
        return this.logger;
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.jobs = new HashMap();
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
    }

    @LifeCycleListener(phase=Phase.START, priority=0)
    public void startup() {
        if (this.done) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Already done");
            }
            return;
        }
        this.done = true;
        List list = this.scanner.scan();
        this.initialize(list.size());
        for (Job job : list) {
            try {
                this.startJob(job);
            }
            catch (DSBException dSBException) {
                dSBException.printStackTrace();
            }
        }
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @LifeCycleListener(phase=Phase.STOP, priority=0)
    public void shutdown() {
        List list = this.registry.get();
        for (Job job : list) {
            try {
                this.stopJob(job);
            }
            catch (DSBException dSBException) {
                dSBException.printStackTrace();
            }
        }
    }

    public void initialize(int n) {
        this.scheduler = Executors.newScheduledThreadPool(n);
        this.initialized = true;
    }

    public String startJob(final Job job) throws DSBException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Starting job " + job));
        }
        if (!this.initialized) {
            throw new DSBException("Not initialized");
        }
        Runnable runnable = new Runnable(){

            public void run() {
                Method method = job.getMethod();
                Object object = job.getTarget();
                if (object != null && method != null) {
                    try {
                        CronManagerImpl.this.log.debug((Object)("Invoking cron method " + object.getClass() + " - " + method.getName()));
                        method.invoke(object, null);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        illegalArgumentException.printStackTrace();
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        illegalAccessException.printStackTrace();
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        invocationTargetException.printStackTrace();
                    }
                }
            }
        };
        ScheduledFuture<?> scheduledFuture = this.scheduler.scheduleAtFixedRate(runnable, job.getDelay(), job.getPeriod(), job.getUnit());
        String string = "job-" + UUID.randomUUID().toString();
        job.setId(string);
        this.jobs.put(string, scheduledFuture);
        this.registry.store(job);
        return string;
    }

    public void stopJob(Job job) throws DSBException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Stopping job " + job));
        }
        if (!this.initialized) {
            throw new DSBException("Not initialized");
        }
        if (this.jobs.get(job.getId()) == null) {
            throw new DSBException("No such job '%s'", new Object[]{job.getId()});
        }
        ScheduledFuture<?> scheduledFuture = this.jobs.remove(job.getId());
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
    }

    public List<CronJobBean> get() {
        List list = this.registry.get();
        ArrayList<CronJobBean> arrayList = new ArrayList<CronJobBean>(list.size());
        for (Job job : list) {
            CronJobBean cronJobBean = new CronJobBean();
            cronJobBean.setDelay(job.getDelay());
            cronJobBean.setId(job.getId());
            cronJobBean.setMethod(job.getMethod().getName());
            cronJobBean.setPeriod(job.getPeriod());
            cronJobBean.setTarget(job.getTarget().getClass().getName());
            cronJobBean.setUnit(job.getUnit().toString());
            arrayList.add(cronJobBean);
        }
        return arrayList;
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("cron-registry")) {
            if (!CronRegistry.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + CronRegistry.class.getName());
            }
            this.registry = (CronRegistry)object;
            return;
        }
        if (string.equals("cron-scanner")) {
            if (!CronScanner.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + CronScanner.class.getName());
            }
            this.scanner = (CronScanner)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("cron-registry");
        arrayList.add("cron-scanner");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("cron-registry")) {
            return this.registry;
        }
        if (string.equals("cron-scanner")) {
            return this.scanner;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("cron-registry")) {
            this.registry = null;
            return;
        }
        if (string.equals("cron-scanner")) {
            this.scanner = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

