/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.tools.service.sample;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.util.oldies.LoggingUtil;
import org.petalslink.dsb.soap.api.Service;
import org.petalslink.dsb.soap.api.ServiceException;
import org.petalslink.dsb.soap.api.SimpleExchange;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=Service.class)})
public class HelloService
implements BindingController,
LifeCycleController,
Service {
    private Logger logger;
    private LoggingUtil log;
    private LoggerFactory loggerFactory;

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        System.out.println(String.format("Starting simple hello service provider (will be available at %s)", this.getURL()));
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
    }

    public String getWSDLURL() {
        return "helloservice.wsdl";
    }

    public String getURL() {
        return "http://localhost:6789/foo/bar/HelloService";
    }

    public Logger getLogger() {
        return this.logger;
    }

    public QName getService() {
        return new QName("http://api.ws.dsb.petalslink.org/", "HelloServiceService");
    }

    public QName getInterface() {
        return null;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public QName getEndpoint() {
        return new QName("http://api.ws.dsb.petalslink.org/", "HelloServicePort");
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public void invoke(SimpleExchange simpleExchange) throws ServiceException {
        System.out.println("I have been invoked!");
        System.out.println(simpleExchange.getOperation());
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList arrayList = new ArrayList();
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

