/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.tools.ws;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.fractal.util.Fractal;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.util.oldies.LoggingUtil;
import org.petalslink.dsb.fractal.utils.FractalHelper;
import org.petalslink.dsb.kernel.api.tools.ws.WebServiceInformationBean;
import org.petalslink.dsb.kernel.api.tools.ws.WebServiceRegistry;
import org.petalslink.dsb.kernel.tools.ws.FractalWSHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=WebServiceRegistry.class)})
public class GlobalWebServiceRegistryImpl
implements BindingController,
LifeCycleController,
WebServiceRegistry {
    private Logger logger;
    private LoggingUtil log;
    private Component component;
    Set<WebServiceInformationBean> webservices;
    private LoggerFactory loggerFactory;

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.debug((Object)"Starting...");
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.debug((Object)"Stopping...");
    }

    public Logger getLogger() {
        return this.logger;
    }

    public synchronized void load() {
        Component component = FractalHelper.getRootComponent((Component)this.component);
        try {
            Set<WebServiceInformationBean> set = FractalWSHelper.getAllBeans(Fractal.getContentController((Component)component));
            if (this.webservices == null) {
                this.webservices = new HashSet<WebServiceInformationBean>();
            }
            this.webservices.addAll(set);
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            noSuchInterfaceException.printStackTrace();
        }
        if (this.log.isDebugEnabled()) {
            int n = 0;
            this.log.debug((Object)"Found the following services in the framework :");
            for (WebServiceInformationBean webServiceInformationBean : this.webservices) {
                this.log.debug((Object)(String.valueOf(n++) + " : " + webServiceInformationBean));
            }
        }
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public Set<WebServiceInformationBean> getWebServices() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Entering method : getWebServices");
        }
        if (this.webservices == null) {
            this.webservices = new HashSet<WebServiceInformationBean>();
            this.load();
        }
        return new HashSet<WebServiceInformationBean>(this.webservices);
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("component")) {
            this.component = (Component)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList arrayList = new ArrayList();
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

