/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.tools.ws;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.tools.ws.WebServiceManager;
import org.ow2.petals.util.oldies.LoggingUtil;
import org.petalslink.dsb.kernel.api.tools.ws.WebServiceException;
import org.petalslink.dsb.kernel.api.tools.ws.WebServiceExposer;
import org.petalslink.dsb.kernel.api.tools.ws.WebServiceInformationBean;
import org.petalslink.dsb.kernel.api.tools.ws.WebServiceRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=WebServiceManager.class)})
public class WebServiceManagerImpl
implements BindingController,
LifeCycleController,
WebServiceManager {
    private Logger logger;
    private LoggingUtil log;
    private LoggerFactory loggerFactory;
    @Requires(name="wsregistry", signature=WebServiceRegistry.class)
    private WebServiceRegistry webServiceRegistry;
    @Requires(name="wsexposer", signature=WebServiceExposer.class)
    private WebServiceExposer webServiceExposer;
    private boolean exposed;
    private Set<WebServiceInformationBean> services;

    public Logger getLogger() {
        return this.logger;
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.debug((Object)"Starting...");
        this.services = new HashSet<WebServiceInformationBean>();
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.debug((Object)"Stopping...");
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public synchronized void exposeServices() throws org.ow2.petals.tools.ws.WebServiceException {
        if (!this.exposed) {
            Set set;
            Set set2 = set = this.webServiceRegistry.getWebServices();
            Set set3 = null;
            try {
                set3 = this.webServiceExposer.expose(set2);
            }
            catch (WebServiceException webServiceException) {
                throw new org.ow2.petals.tools.ws.WebServiceException((Throwable)webServiceException);
            }
            if (set3 != null) {
                this.services.addAll(set3);
            }
        } else {
            throw new org.ow2.petals.tools.ws.WebServiceException("Services already exposed");
        }
        this.exposed = true;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public List<String> getServiceNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (WebServiceInformationBean webServiceInformationBean : this.services) {
            arrayList.add(webServiceInformationBean.name);
        }
        return arrayList;
    }

    public List<String> getServicesURL() throws org.ow2.petals.tools.ws.WebServiceException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (WebServiceInformationBean webServiceInformationBean : this.services) {
            arrayList.add(webServiceInformationBean.url);
        }
        return arrayList;
    }

    public void removeService(String string) throws org.ow2.petals.tools.ws.WebServiceException {
        try {
            this.webServiceExposer.remove(string);
        }
        catch (WebServiceException webServiceException) {
            throw new org.ow2.petals.tools.ws.WebServiceException((Throwable)webServiceException);
        }
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("wsregistry")) {
            if (!WebServiceRegistry.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + WebServiceRegistry.class.getName());
            }
            this.webServiceRegistry = (WebServiceRegistry)object;
            return;
        }
        if (string.equals("wsexposer")) {
            if (!WebServiceExposer.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + WebServiceExposer.class.getName());
            }
            this.webServiceExposer = (WebServiceExposer)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("wsregistry");
        arrayList.add("wsexposer");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("wsregistry")) {
            return this.webServiceRegistry;
        }
        if (string.equals("wsexposer")) {
            return this.webServiceExposer;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("wsregistry")) {
            this.webServiceRegistry = null;
            return;
        }
        if (string.equals("wsexposer")) {
            this.webServiceExposer = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

