/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.ws;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.tools.ws.KernelWebService;
import org.ow2.petals.util.oldies.LoggingUtil;
import org.petalslink.dsb.kernel.api.management.binder.NewServiceExposer;
import org.petalslink.dsb.ws.api.ExposerService;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=KernelWebService.class), @Interface(name="webservice", signature=ExposerService.class)})
public class ExposerServiceImpl
implements BindingController,
LifeCycleController,
KernelWebService,
ExposerService {
    private Logger logger;
    private LoggingUtil log;
    private LoggerFactory loggerFactory;
    private Component component;
    @Requires(name="new-service-exposer", signature=NewServiceExposer.class)
    private NewServiceExposer exposer;
    private ExecutorService executorService;

    public Logger getLogger() {
        return this.logger;
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.debug((Object)"Starting...");
        this.executorService = Executors.newSingleThreadExecutor();
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.debug((Object)"Stopping...");
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public Component getComponent() {
        return this.component;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void expose() {
        this.log.debug((Object)"Got an #expose WS call, submitting it to executor...");
        this.executorService.submit(new Runnable(){

            public void run() {
                ExposerServiceImpl.this.exposer.expose();
            }
        });
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("component")) {
            this.component = (Component)object;
            return;
        }
        if (string.equals("new-service-exposer")) {
            if (!NewServiceExposer.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + NewServiceExposer.class.getName());
            }
            this.exposer = (NewServiceExposer)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("new-service-exposer");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("new-service-exposer")) {
            return this.exposer;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("new-service-exposer")) {
            this.exposer = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

