/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.ws;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.jbi.messaging.registry.EndpointRegistry;
import org.ow2.petals.jbi.messaging.registry.RegistryException;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.util.oldies.LoggingUtil;
import org.petalslink.dsb.kernel.api.management.component.ComponentInformationService;
import org.petalslink.dsb.kernel.util.EndpointHelper;
import org.petalslink.dsb.ws.api.DSBWebServiceException;
import org.petalslink.dsb.ws.api.PlatformServiceInformationService;
import org.petalslink.dsb.ws.api.ServiceEndpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=PlatformServiceInformationService.class)})
public class PlatformServiceInformationServiceImpl
implements BindingController,
LifeCycleController,
PlatformServiceInformationService {
    private Logger logger;
    private LoggerFactory loggerFactory;
    private LoggingUtil log;
    @Requires(name="endpointregistry", signature=EndpointRegistry.class)
    private EndpointRegistry endpointRegistry;
    @Requires(name="component-information", signature=ComponentInformationService.class)
    private ComponentInformationService componentInformationService;
    @Requires(name="configuration", signature=ConfigurationService.class)
    private ConfigurationService configurationService;

    public Logger getLogger() {
        return this.logger;
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.debug((Object)"Starting...");
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.debug((Object)"Stopping...");
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getPlatformRESTService(String string) throws DSBWebServiceException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Entering method : getPlatformRESTService with params restURL = " + string));
        }
        String string2 = this.getRESTServiceAddress();
        ServiceEndpoint serviceEndpoint = this.getRESTServiceEndpoint(string);
        if (serviceEndpoint == null) {
            return null;
        }
        String string3 = this.getRESTServiceName(serviceEndpoint);
        return String.valueOf(string2) + string3;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public String getPlatformWebService(String string) throws DSBWebServiceException {
        List<ServiceEndpoint> list;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Entering method : getPlatformWebService with params wsdlURL = " + string));
        }
        if ((list = this.getWebServiceEndpoint(string)) == null || list.size() == 0) {
            return null;
        }
        String string2 = this.getWebServiceAddress();
        String string3 = this.getSOAPServiceName(list.get(0));
        return String.valueOf(string2) + string3;
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    private String getSOAPServiceName(ServiceEndpoint serviceEndpoint) {
        String string = serviceEndpoint.getEndpoint();
        if (string.startsWith("SoapPlatform")) {
            string = string.substring("SoapPlatform".length(), string.length());
        }
        return String.valueOf(string) + "Service";
    }

    private String getWebServiceAddress() {
        String string = this.componentInformationService.getProperty("petals-bc-soap", "service");
        if (string == null) {
            return "";
        }
        String string2 = string.replaceAll("\\$HOST", this.configurationService.getContainerConfiguration().getHost());
        if (string2.charAt(string2.length() - 1) != '/') {
            string2 = String.valueOf(string2) + "/";
        }
        return string2;
    }

    public ServiceEndpoint getRESTServiceEndpoint(String string) throws DSBWebServiceException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Entering method : getRESTServiceEndpoint with params restURL = " + string));
        }
        try {
            return EndpointHelper.getRESTEndpoint(new URI(string));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new DSBWebServiceException(uRISyntaxException.getMessage());
        }
    }

    public List<ServiceEndpoint> getWebServiceEndpoint(String string) throws DSBWebServiceException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Entering method : getWebServiceEndpoint with params wsdlURI = " + string));
        }
        try {
            return EndpointHelper.getEndpoints(new URI(string));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new DSBWebServiceException(uRISyntaxException.getMessage());
        }
    }

    public boolean isRESTServiceBound(String string) throws DSBWebServiceException {
        ServiceEndpoint serviceEndpoint;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Entering method : isRESTServiceBound with params restURL = " + string));
        }
        if ((serviceEndpoint = this.getRESTServiceEndpoint(string)) == null) {
            throw new DSBWebServiceException("Can not generate an Endpoint from the given URL " + string);
        }
        List list = null;
        try {
            list = this.endpointRegistry.query(serviceEndpoint.getEndpoint(), serviceEndpoint.getItf(), serviceEndpoint.getService(), null, null, null, null);
        }
        catch (RegistryException registryException) {
            throw new DSBWebServiceException(registryException.getMessage());
        }
        return list != null && list.size() > 0;
    }

    public boolean isWebServiceBound(String string) throws DSBWebServiceException {
        List<ServiceEndpoint> list;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Entering method : isWebServiceBound with params wsdlURL = " + string));
        }
        if ((list = this.getWebServiceEndpoint(string)) == null) {
            throw new DSBWebServiceException("Can not generate an Endpoint from the given URL " + string);
        }
        ArrayList arrayList = new ArrayList();
        for (ServiceEndpoint serviceEndpoint : list) {
            try {
                arrayList.addAll(this.endpointRegistry.query(serviceEndpoint.getEndpoint(), serviceEndpoint.getItf(), serviceEndpoint.getService(), null, null, null, null));
            }
            catch (RegistryException registryException) {
                this.log.warning((Object)registryException.getMessage());
            }
        }
        return arrayList != null && arrayList.size() > 0;
    }

    private String getRESTServiceAddress() {
        String string = this.componentInformationService.getProperty("petals-bc-rest", "service");
        if (string == null) {
            return "";
        }
        String string2 = string.replaceAll("\\$HOST", this.configurationService.getContainerConfiguration().getHost());
        if (string2.charAt(string2.length() - 1) != '/') {
            string2 = String.valueOf(string2) + "/";
        }
        return string2;
    }

    private String getRESTServiceName(ServiceEndpoint serviceEndpoint) {
        String string = serviceEndpoint.getEndpoint();
        if (string.startsWith("RestPlatform")) {
            string = string.substring("RestPlatform".length(), string.length());
        }
        return serviceEndpoint != null ? String.valueOf(string) + "Service" : "";
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("endpointregistry")) {
            if (!EndpointRegistry.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + EndpointRegistry.class.getName());
            }
            this.endpointRegistry = (EndpointRegistry)object;
            return;
        }
        if (string.equals("component-information")) {
            if (!ComponentInformationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ComponentInformationService.class.getName());
            }
            this.componentInformationService = (ComponentInformationService)object;
            return;
        }
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("endpointregistry");
        arrayList.add("component-information");
        arrayList.add("configuration");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("endpointregistry")) {
            return this.endpointRegistry;
        }
        if (string.equals("component-information")) {
            return this.componentInformationService;
        }
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("endpointregistry")) {
            this.endpointRegistry = null;
            return;
        }
        if (string.equals("component-information")) {
            this.componentInformationService = null;
            return;
        }
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

