/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.ws;

import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.util.oldies.LoggingUtil;
import org.petalslink.dsb.kernel.api.management.component.ComponentInformationService;
import org.petalslink.dsb.ws.api.DSBWebServiceException;
import org.petalslink.dsb.ws.api.ProxyInformationService;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=ProxyInformationService.class)})
public class ProxyInformationServiceImpl
implements BindingController,
LifeCycleController,
ProxyInformationService {
    private Logger logger;
    private LoggingUtil log;
    @Requires(name="component-information", signature=ComponentInformationService.class)
    private ComponentInformationService componentInformationService;
    private LoggerFactory loggerFactory;
    @Requires(name="configuration", signature=ConfigurationService.class)
    private ConfigurationService configurationService;

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.debug((Object)"Starting...");
    }

    public Logger getLogger() {
        return this.logger;
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.debug((Object)"Stopping...");
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public String getRESTProxy(String string) throws DSBWebServiceException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Entering method : getRESTProxy with params restURL = " + string));
        }
        if (string == null) {
            throw new DSBWebServiceException("Null URL is not allowed...");
        }
        try {
            URI.create(string).toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new DSBWebServiceException(malformedURLException.getMessage());
        }
        String string2 = null;
        String string3 = this.componentInformationService.getProperty("petals-bc-rest", "proxy");
        if (string3 == null) {
            throw new DSBWebServiceException("Can not define the proy URL, the REST component seems to be inactive");
        }
        string2 = string3.replaceAll("\\$HOST", this.configurationService.getContainerConfiguration().getHost());
        if (string2.charAt(string2.length() - 1) != '/') {
            string2 = String.valueOf(string2) + "/";
        }
        string2 = String.valueOf(string2) + string;
        return string2;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public String getSOAPProxy(String string) throws DSBWebServiceException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Entering method : getSOAPProxy with params wsdlURL = " + string));
        }
        if (string == null) {
            throw new DSBWebServiceException("Null URL is not allowed...");
        }
        try {
            URI.create(string).toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new DSBWebServiceException(malformedURLException.getMessage());
        }
        String string2 = null;
        String string3 = this.componentInformationService.getProperty("petals-bc-rest", "proxy");
        if (string3 == null) {
            throw new DSBWebServiceException("Can not define the proy URL, the REST component seems to be inactive");
        }
        string2 = string3.replaceAll("\\$HOST", this.configurationService.getContainerConfiguration().getHost());
        if (string2.charAt(string2.length() - 1) != '/') {
            string2 = String.valueOf(string2) + "/";
        }
        string2 = String.valueOf(string2) + string;
        return string2;
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("component-information")) {
            if (!ComponentInformationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ComponentInformationService.class.getName());
            }
            this.componentInformationService = (ComponentInformationService)object;
            return;
        }
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("component-information");
        arrayList.add("configuration");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("component-information")) {
            return this.componentInformationService;
        }
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("component-information")) {
            this.componentInformationService = null;
            return;
        }
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

