/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.ws;

import java.util.ArrayList;
import java.util.Set;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.tools.ws.KernelWebService;
import org.ow2.petals.util.oldies.LoggingUtil;
import org.petalslink.dsb.kernel.api.management.binder.BinderException;
import org.petalslink.dsb.kernel.api.management.binder.ServiceExposer;
import org.petalslink.dsb.kernel.api.management.binder.ServiceExposerRegistry;
import org.petalslink.dsb.ws.api.DSBWebServiceException;
import org.petalslink.dsb.ws.api.SOAPServiceExposer;
import org.petalslink.dsb.ws.api.ServiceEndpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=KernelWebService.class), @Interface(name="webservice", signature=SOAPServiceExposer.class)})
public class SOAPServiceExposerServiceImpl
implements BindingController,
LifeCycleController,
KernelWebService,
SOAPServiceExposer {
    private Logger logger;
    private LoggingUtil log;
    private Component component;
    @Requires(name="exposer-registry", signature=ServiceExposerRegistry.class)
    private ServiceExposerRegistry serviceExposerRegistry;
    private LoggerFactory loggerFactory;

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.debug((Object)"Starting...");
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.debug((Object)"Stopping...");
    }

    public Logger getLogger() {
        return this.logger;
    }

    public boolean expose(ServiceEndpoint serviceEndpoint) throws DSBWebServiceException {
        this.log.call();
        ServiceExposer serviceExposer = this.serviceExposerRegistry.getServiceExposer("soap");
        if (serviceExposer == null) {
            throw new DSBWebServiceException("Can not find a valid service exposer for protocol 'soap'");
        }
        try {
            serviceExposer.expose(serviceEndpoint);
        }
        catch (BinderException binderException) {
            if (this.log.isDebugEnabled()) {
                this.log.warning((Object)"Can not expose service due to internal problem", (Throwable)binderException);
            } else {
                this.log.warning((Object)("Can not expose service due to internal problem : " + binderException.getMessage()));
            }
            throw new DSBWebServiceException("Can not expose service due to internal problem", (Throwable)binderException);
        }
        return true;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public boolean delete(ServiceEndpoint serviceEndpoint) throws DSBWebServiceException {
        throw new DSBWebServiceException("Not implemented");
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public Set<String> getWebServices() throws DSBWebServiceException {
        throw new DSBWebServiceException("Not implemented");
    }

    public Component getComponent() {
        return this.component;
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("component")) {
            this.component = (Component)object;
            return;
        }
        if (string.equals("exposer-registry")) {
            if (!ServiceExposerRegistry.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ServiceExposerRegistry.class.getName());
            }
            this.serviceExposerRegistry = (ServiceExposerRegistry)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("exposer-registry");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("exposer-registry")) {
            return this.serviceExposerRegistry;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("exposer-registry")) {
            this.serviceExposerRegistry = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

