/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.ws;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.tools.ws.KernelWebService;
import org.ow2.petals.util.oldies.LoggingUtil;
import org.petalslink.dsb.kernel.api.management.component.ComponentInformationService;
import org.petalslink.dsb.ws.api.ServiceInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=KernelWebService.class), @Interface(name="webservice", signature=ServiceInformation.class)})
public class ServiceInformationImpl
implements BindingController,
LifeCycleController,
KernelWebService,
ServiceInformation {
    private Component component;
    private Logger logger;
    private LoggerFactory loggerFactory;
    private LoggingUtil log;
    @Requires(name="component-information", signature=ComponentInformationService.class)
    private ComponentInformationService componentInformationService;
    @Requires(name="configuration", signature=ConfigurationService.class)
    private ConfigurationService configurationService;

    public Logger getLogger() {
        return this.logger;
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.debug((Object)"Starting...");
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.debug((Object)"Stopping...");
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Set<String> getExposedWebServices() {
        Set set = this.componentInformationService.getExposedServiceURLs("petals-bc-soap");
        HashSet<String> hashSet = new HashSet<String>(set.size());
        for (String string : set) {
            hashSet.add(string.replaceAll("\\$HOST", this.configurationService.getContainerConfiguration().getHost()));
        }
        return hashSet;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public Component getComponent() {
        return this.component;
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public Set<String> getConsumedRESTServices() {
        Set set = this.componentInformationService.getConsumedServiceURLs("petals-bc-rest");
        HashSet<String> hashSet = new HashSet<String>(set.size());
        for (String string : set) {
            hashSet.add(string.replaceAll("\\$HOST", this.configurationService.getContainerConfiguration().getHost()));
        }
        return hashSet;
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public Set<String> getConsumedWebServices() {
        Set set = this.componentInformationService.getConsumedServiceURLs("petals-bc-soap");
        HashSet<String> hashSet = new HashSet<String>(set.size());
        for (String string : set) {
            hashSet.add(string.replaceAll("\\$HOST", this.configurationService.getContainerConfiguration().getHost()));
        }
        return hashSet;
    }

    public Set<String> getExposedRESTServices() {
        Set set = this.componentInformationService.getExposedServiceURLs("petals-bc-rest");
        HashSet<String> hashSet = new HashSet<String>(set.size());
        for (String string : set) {
            hashSet.add(string.replaceAll("\\$HOST", this.configurationService.getContainerConfiguration().getHost()));
        }
        return hashSet;
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("component")) {
            this.component = (Component)object;
            return;
        }
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("component-information")) {
            if (!ComponentInformationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ComponentInformationService.class.getName());
            }
            this.componentInformationService = (ComponentInformationService)object;
            return;
        }
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("component-information");
        arrayList.add("configuration");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("component-information")) {
            return this.componentInformationService;
        }
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("component-information")) {
            this.componentInformationService = null;
            return;
        }
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

