/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.ws.jbi;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.container.lifecycle.ServiceAssemblyLifeCycle;
import org.ow2.petals.container.lifecycle.ServiceUnitLifeCycle;
import org.ow2.petals.jbi.descriptor.JBIDescriptorException;
import org.ow2.petals.jbi.descriptor.original.JBIDescriptorBuilder;
import org.ow2.petals.jbi.descriptor.original.generated.Jbi;
import org.ow2.petals.jbi.descriptor.original.generated.ServiceAssembly;
import org.ow2.petals.jbi.management.admin.AdminService;
import org.ow2.petals.util.oldies.LoggingUtil;
import org.petalslink.dsb.ws.api.DSBWebServiceException;
import org.petalslink.dsb.ws.api.jbi.ServiceArtefactsInformationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=ServiceArtefactsInformationService.class)})
public class ServiceArtefactsInformationServiceImpl
implements BindingController,
LifeCycleController,
ServiceArtefactsInformationService {
    private Logger logger;
    private LoggingUtil log;
    @Requires(name="admin", signature=AdminService.class)
    private AdminService adminService;
    private static Marshaller marshaller = null;
    private LoggerFactory loggerFactory;

    static {
        try {
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{ServiceAssembly.class});
            marshaller = jAXBContext.createMarshaller();
        }
        catch (JAXBException jAXBException) {}
    }

    public Logger getLogger() {
        return this.logger;
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Set<String> getSUForSA(String string) throws DSBWebServiceException {
        this.log.start();
        ServiceAssemblyLifeCycle serviceAssemblyLifeCycle = this.adminService.getServiceAssemblyByName(string);
        if (serviceAssemblyLifeCycle == null) {
            throw new DSBWebServiceException("SA %s not found", new Object[]{string});
        }
        HashSet<String> hashSet = new HashSet<String>();
        List list = serviceAssemblyLifeCycle.getServiceUnitLifeCycles();
        for (ServiceUnitLifeCycle serviceUnitLifeCycle : list) {
            hashSet.add(serviceUnitLifeCycle.getSuName());
        }
        return hashSet;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public Set<String> getSUForComponent(String string) throws DSBWebServiceException {
        this.log.start();
        HashSet<String> hashSet = new HashSet<String>();
        List list = this.adminService.getServiceUnitsLifeCyclesForComponent(string);
        if (list == null) {
            throw new DSBWebServiceException("Component %s not found", new Object[]{string});
        }
        for (ServiceUnitLifeCycle serviceUnitLifeCycle : list) {
            hashSet.add(serviceUnitLifeCycle.getSuName());
        }
        return hashSet;
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public String getSUDescription(String string, String string2) throws DSBWebServiceException {
        this.log.start();
        if (string == null) {
            throw new DSBWebServiceException("SA name should not be null...");
        }
        if (string2 == null) {
            throw new DSBWebServiceException("SU name should not be null...");
        }
        ServiceAssemblyLifeCycle serviceAssemblyLifeCycle = this.adminService.getServiceAssemblyByName(string);
        if (serviceAssemblyLifeCycle == null) {
            throw new DSBWebServiceException("SA %s not found", new Object[]{string});
        }
        String string3 = null;
        List list = serviceAssemblyLifeCycle.getServiceUnitLifeCycles();
        for (ServiceUnitLifeCycle serviceUnitLifeCycle : list) {
            if (!string2.equals(serviceUnitLifeCycle.getSuName())) continue;
            Jbi jbi = serviceUnitLifeCycle.getServiceUnitDescriptor();
            try {
                string3 = JBIDescriptorBuilder.buildXmlStringJBIdescriptor((Jbi)jbi);
            }
            catch (JBIDescriptorException jBIDescriptorException) {
                throw new DSBWebServiceException("Error while creating descriptor", (Throwable)jBIDescriptorException);
            }
        }
        if (string3 == null) {
            throw new DSBWebServiceException("No descriptor found for SU %s in SA %s", new Object[]{string2, string});
        }
        return string3;
    }

    public Set<String> getSAs() throws DSBWebServiceException {
        this.log.start();
        HashSet<String> hashSet = new HashSet<String>();
        Set set = this.adminService.getServiceAssemblies().keySet();
        if (set != null) {
            hashSet.addAll(set);
        }
        return hashSet;
    }

    public String getSADescription(String string) throws DSBWebServiceException {
        this.log.start();
        if (string == null) {
            throw new DSBWebServiceException("SA name should not be null...");
        }
        ServiceAssemblyLifeCycle serviceAssemblyLifeCycle = this.adminService.getServiceAssemblyByName(string);
        if (serviceAssemblyLifeCycle == null) {
            throw new DSBWebServiceException("SA %s not found", new Object[]{string});
        }
        ServiceAssembly serviceAssembly = serviceAssemblyLifeCycle.getServiceAssembly();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            marshaller.marshal((Object)serviceAssembly, (OutputStream)byteArrayOutputStream);
        }
        catch (JAXBException jAXBException) {
            throw new DSBWebServiceException("Unable to generate the descriptor...", (Throwable)jAXBException);
        }
        return byteArrayOutputStream.toString();
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("admin")) {
            if (!AdminService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + AdminService.class.getName());
            }
            this.adminService = (AdminService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("admin");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("admin")) {
            return this.adminService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("admin")) {
            this.adminService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

