/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.launcher;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.naming.ConfigurationException;
import javax.xml.bind.JAXBException;
import org.ow2.petals.jmx.JMXClient;
import org.ow2.petals.jmx.exception.ConnectionErrorException;
import org.ow2.petals.jmx.exception.PetalsAdminDoesNotExistException;
import org.ow2.petals.jmx.exception.PetalsAdminServiceErrorException;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.kernel.api.server.PetalsServer;
import org.ow2.petals.kernel.api.server.util.SystemUtil;
import org.ow2.petals.launcher.PetalsLauncher;
import org.ow2.petals.launcher.util.CommandReader;
import org.ow2.petals.launcher.util.Locker;
import org.ow2.petals.launcher.util.SystemExitHook;
import org.ow2.petals.topology.TopologyException;
import org.petalslink.dsb.launcher.PetalsStateListener;

public abstract class AbstractLauncher
implements PetalsStateListener,
PetalsLauncher {
    protected static final String START_COMMAND = "start";
    protected static final String STOP_COMMAND = "stop";
    protected static final String SHUTDOWN_COMMAND = "shutdown";
    protected static final String VERSION_COMMAND = "version";
    public static final String PROPERTY_CONTAINER_NAME = "petals.container.name";
    protected PetalsServer petalsServer;
    protected SystemExitHook systemExitHook;
    private final Locker locker = new Locker(SystemUtil.getPetalsInstallDirectory());
    protected JMXClient jmxClient;

    public AbstractLauncher() {
        this.showBanner();
    }

    protected void showBanner() {
        System.out.println();
        System.out.println(" -----------------------------------------------------------");
        System.out.println("|                                                           |");
        System.out.println("|             OW2 PEtALS Enterprise Service Bus             |");
        System.out.println("|                   http://petals.ow2.org                   |");
        System.out.println("|                                                           |");
        System.out.println(" -----------------------------------------------------------");
        System.out.println();
    }

    @SuppressWarnings(value={"Dm"}, justification="System.exit(...) are used in the right place.")
    public void launch(String[] args) {
        String command = null;
        boolean console = false;
        if (args.length == 0) {
            this.printUsage();
            System.exit(-1);
        }
        for (String arg : args) {
            if ("-console".equals(arg)) {
                console = true;
                continue;
            }
            command = arg;
        }
        try {
            if (STOP_COMMAND.equals(command)) {
                System.out.println("PEtALS ESB is stopping...");
                this.stop();
            } else if (SHUTDOWN_COMMAND.equals(command)) {
                System.out.println("PEtALS ESB is shutting down...");
                this.shutdown();
            } else if (VERSION_COMMAND.equals(command)) {
                this.version();
            } else if (START_COMMAND.equals(command)) {
                System.out.println("PEtALS ESB is starting...");
                this.start();
                if (console) {
                    this.commandLineMode();
                }
            } else {
                System.out.println("Command '" + command + "' is unknown");
                this.printUsage();
                System.exit(-1);
            }
        }
        catch (Throwable e) {
            System.out.println("Command processing error : " + command);
            e.printStackTrace(System.err);
            if (this.systemExitHook != null) {
                Runtime.getRuntime().removeShutdownHook(this.systemExitHook);
            }
            System.exit(-1);
        }
    }

    public void start() throws Exception {
        if (this.locker.isLocked()) {
            throw new PetalsException("Can not start the PEtALS server, remove lock file from PEtALS root path or stop server");
        }
        this.petalsServer = this.loadPetalsServer();
        this.systemExitHook = new SystemExitHook(this.petalsServer, this.locker, this);
        Runtime.getRuntime().addShutdownHook(this.systemExitHook);
        this.petalsServer.init();
        this.petalsServer.start();
        System.out.println("System Information : " + this.getJMXClient().getAdminServiceClient().getSystemInfo());
    }

    public void stop() throws Exception {
        this.getJMXClient().getPetalsAdminServiceClient().stopContainer();
    }

    public void shutdown() throws Exception {
        this.getJMXClient().getPetalsAdminServiceClient().shutdownContainer();
    }

    public void version() throws Exception {
        System.out.println(this.getJMXClient().getAdminServiceClient().getSystemInfo());
    }

    protected void printUsage() {
        System.out.println("usage:");
        System.out.println(" -start [-console]       start the PEtALS container");
        System.out.println(" -stop                   stop the PEtALS container");
        System.out.println(" -shutdown               shutdown the PEtALS container");
        System.out.println(" -version                get the PEtALS container version");
    }

    private void printStartedMessage() {
        this.printSpecificStartMessage();
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat sdf = new SimpleDateFormat();
        System.out.println();
        System.out.println("PEtALS ESB " + this.getDistributionName() + " distribution successfully started - " + sdf.format(date));
    }

    protected void printSpecificStartMessage() {
    }

    public void onPetalsStarted() {
        this.locker.lock();
        this.printStartedMessage();
    }

    @SuppressWarnings(value={"Dm"}, justification="System.exit(...) are used in the right place.")
    public void onPetalsStopped(boolean success, Exception exception) {
        Runtime.getRuntime().removeShutdownHook(this.systemExitHook);
        this.locker.unlock();
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat sdf = new SimpleDateFormat();
        if (success) {
            System.out.println("PEtALS ESB " + this.getDistributionName() + " distribution is stopped - " + sdf.format(date));
            System.exit(0);
        } else {
            exception.printStackTrace();
            System.out.println("PEtALS ESB " + this.getDistributionName() + " distribution is not properly stopped - " + sdf.format(date));
            System.exit(-1);
        }
    }

    protected abstract JMXClient getJMXClient() throws IOException, JAXBException, TopologyException, ConnectionErrorException, PetalsAdminDoesNotExistException, PetalsAdminServiceErrorException, ConfigurationException;

    protected void commandLineMode() throws ConnectionErrorException, PetalsAdminDoesNotExistException, PetalsAdminServiceErrorException, IOException, JAXBException, TopologyException, ConfigurationException {
        CommandReader console = new CommandReader(this.getJMXClient(), this.petalsServer);
        console.read();
    }

    protected PetalsServer loadPetalsServer() throws IOException, ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        File petalsKernelFile = this.getBootstrapJAR();
        if (petalsKernelFile == null) {
            throw new IOException("Failed to get the PEtALS bootstrap file");
        }
        URLClassLoader petalsKernelClassLoader = new URLClassLoader(new URL[]{petalsKernelFile.toURI().toURL()}, AbstractLauncher.class.getClassLoader());
        Class<?> petalsKernelClass = petalsKernelClassLoader.loadClass("org.ow2.petals.kernel.server.PetalsServerImpl");
        PetalsServer newPetalsServer = (PetalsServer)petalsKernelClass.newInstance();
        Thread.currentThread().setContextClassLoader(petalsKernelClassLoader);
        return newPetalsServer;
    }

    protected File getBootstrapJAR() {
        File bootstrapFile = null;
        File libDirectory = new File(SystemUtil.getPetalsInstallDirectory() + File.separator + "lib");
        for (File file : libDirectory.listFiles()) {
            if (!file.getName().matches("petals-kernel-[0-9.]+\\.jar") && !file.getName().matches("petals-kernel-[0-9.]+-SNAPSHOT\\.jar")) continue;
            bootstrapFile = file;
            break;
        }
        return bootstrapFile;
    }

    protected abstract String getDistributionName();
}

