/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.launcher.tasks;

import java.util.List;
import javax.management.ObjectName;
import org.ow2.petals.jmx.JMXClient;
import org.ow2.petals.launcher.tasks.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetComponentsTask
extends Task {
    private JMXClient client;

    public GetComponentsTask(JMXClient client) {
        this.client = client;
        this.setShortcut("c");
        this.setName("components");
        this.setDescription("Display the installed JBI components");
    }

    @Override
    protected int doProcess(List<String> args) {
        ObjectName[] objectNames = null;
        System.out.println("JBI components on local container");
        System.out.println("Binding Components List : ");
        try {
            objectNames = this.client.getAdminServiceClient().getBindingComponents();
            if (objectNames != null && objectNames.length > 0) {
                for (ObjectName name : objectNames) {
                    System.out.println(" - " + name);
                }
            } else {
                System.out.println(" - NO BINDING COMPONENT");
            }
        }
        catch (Exception e) {
            System.out.println("Error while retrieving Binding Components");
        }
        System.out.println("");
        System.out.println("Service Engines List : ");
        try {
            objectNames = this.client.getAdminServiceClient().getEngineComponents();
            if (objectNames != null && objectNames.length > 0) {
                for (ObjectName name : objectNames) {
                    System.out.println(" - " + name);
                }
            } else {
                System.out.println(" - NO SERVICE ENGINE");
            }
        }
        catch (Exception e) {
            System.out.println("Error while retrieving Service Engines");
        }
        return 1;
    }
}

