/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.launcher.tasks;

import java.io.File;
import java.io.FilenameFilter;
import java.util.List;
import org.ow2.petals.launcher.tasks.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetRepositoryContentTask
extends Task {
    private File repository;

    public GetRepositoryContentTask(File repository) {
        this.repository = repository;
        this.setDescription("Display the repository content");
        this.setName("repositorycontent");
        this.setShortcut("rc");
    }

    @Override
    protected int doProcess(List<String> args) {
        if (this.repository != null && this.repository.exists()) {
            File[] files = this.repository.listFiles(new ComponentNamesFilter());
            if (files != null && files.length > 0) {
                for (File file : files) {
                    System.out.println(" - " + file.getName());
                }
            } else {
                System.out.println("No components in the repository !");
            }
        } else {
            System.out.println("No repository found !");
        }
        return 1;
    }

    private class ComponentNamesFilter
    implements FilenameFilter {
        private ComponentNamesFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(".zip");
        }
    }
}

