/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.launcher.tasks;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.ow2.petals.launcher.tasks.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HotDeployTask
extends Task {
    private final File currentPath;
    private final File installPath;

    public HotDeployTask(File currentPath, File installPath) {
        this.currentPath = currentPath;
        this.installPath = installPath;
        this.setShortcut("hd");
        this.setName("hotdeploy");
        this.setDescription("Install and start a Component, a Service Assembly or a Share Library (possible args [ZIP filePath])");
    }

    @Override
    public int doProcess(List<String> args) {
        String zip = args.get(0);
        File source = new File(zip);
        if (!source.exists()) {
            source = new File(this.currentPath, zip);
        }
        try {
            FileUtils.copyFileToDirectory((File)source, (File)this.installPath);
            Thread.sleep(1000L);
        }
        catch (IOException e) {
            System.out.println("File found, but can not copy and deploy file");
            e.printStackTrace(System.err);
        }
        catch (InterruptedException e) {
            e.printStackTrace(System.err);
        }
        return 1;
    }

    @Override
    public boolean validateArgs(List<String> args) {
        File f;
        boolean result = false;
        if (args != null && args.size() > 0 && !(result = (f = new File(args.get(0))).exists())) {
            System.out.println("File not found : " + f.getAbsolutePath());
        }
        return result;
    }
}

