/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.launcher.tasks;

import java.io.File;
import java.util.List;
import org.ow2.petals.launcher.tasks.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HotUndeployTask
extends Task {
    private final File installedPath;

    public HotUndeployTask(File installedPath) {
        this.installedPath = installedPath;
        this.setShortcut("hu");
        this.setName("hotundeploy");
        this.setDescription("Shutdown and uninstall a Component, a Service Assembly or a Share Library (possible args [ZIP fileName])");
    }

    @Override
    public int doProcess(List<String> args) {
        String zip = args.get(0);
        File installedFile = new File(this.installedPath, zip);
        installedFile.delete();
        return 1;
    }

    @Override
    public boolean validateArgs(List<String> args) {
        File f;
        boolean result = false;
        if (args != null && args.size() > 0 && !(result = (f = new File(this.installedPath, args.get(0))).exists())) {
            System.out.println("File to undeploy not found : " + f.getAbsolutePath());
        }
        return result;
    }
}

