/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.launcher.tasks;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.FileUtils;
import org.ow2.petals.launcher.tasks.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallFromRepositoryTask
extends Task {
    private final File repository;
    private final File installPath;

    public InstallFromRepositoryTask(File repositoryPath, File installPath) {
        this.setDescription("Install artifact from the repository");
        this.setName("repoinstall");
        this.setShortcut("ri");
        this.repository = repositoryPath;
        this.installPath = installPath;
    }

    @Override
    protected int doProcess(List<String> args) {
        String componentToInstall = args.get(0);
        File[] files = this.repository.listFiles(new ComponentNamesFilter());
        if (files == null) {
            System.out.println("No file in repository");
            return -1;
        }
        for (File file : files) {
            String name = this.getComponentName(file);
            if (!name.equals(componentToInstall)) continue;
            System.out.println("Installing component " + componentToInstall + "...");
            FutureTask<String> task = new FutureTask<String>(new FutureInstaller(file, this.installPath));
            Thread t = new Thread(task);
            t.setDaemon(true);
            t.start();
            try {
                System.out.println(task.get(20L, TimeUnit.SECONDS));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            catch (TimeoutException e) {
                System.out.println("Timeout while installing component");
            }
            break;
        }
        return 1;
    }

    @Override
    public boolean validateArgs(List<String> args) {
        return args != null && args.size() > 0;
    }

    private String getComponentName(File file) {
        return file.getName().substring(0, file.getName().indexOf(".zip"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FutureInstaller
    implements Callable<String> {
        private final File source;
        private final File outpath;

        public FutureInstaller(File source, File outpath) {
            this.source = source;
            this.outpath = outpath;
        }

        @Override
        public String call() throws Exception {
            try {
                FileUtils.copyFileToDirectory((File)this.source, (File)this.outpath);
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
                throw e;
            }
            return "File successfully copied to " + this.outpath;
        }
    }

    private class ComponentNamesFilter
    implements FilenameFilter {
        private ComponentNamesFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(".zip");
        }
    }
}

