/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.launcher.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.ow2.petals.jmx.JMXClient;
import org.ow2.petals.jmx.PetalsAdminServiceClient;
import org.ow2.petals.jmx.exception.ConnectionErrorException;
import org.ow2.petals.jmx.exception.PetalsAdminDoesNotExistException;
import org.ow2.petals.jmx.exception.PetalsAdminServiceErrorException;
import org.ow2.petals.kernel.api.server.PetalsServer;
import org.ow2.petals.kernel.api.server.util.SystemUtil;
import org.ow2.petals.launcher.tasks.EndpointListTask;
import org.ow2.petals.launcher.tasks.GetComponentsTask;
import org.ow2.petals.launcher.tasks.GetCurrentPathTask;
import org.ow2.petals.launcher.tasks.HotDeployTask;
import org.ow2.petals.launcher.tasks.HotUndeployTask;
import org.ow2.petals.launcher.tasks.InfoTask;
import org.ow2.petals.launcher.tasks.JNDITask;
import org.ow2.petals.launcher.tasks.SetPathTask;
import org.ow2.petals.launcher.tasks.ShutdownTask;
import org.ow2.petals.launcher.tasks.StopTask;
import org.ow2.petals.launcher.tasks.SynchronizeRegistryTask;
import org.ow2.petals.launcher.tasks.Task;

public class CommandReader {
    protected File currentPath;
    protected File installPath;
    protected File installedPath;
    protected File uninstalledPath;
    protected File repositoryPath;
    protected PetalsAdminServiceClient petalsService;
    protected PetalsServer petalsServer;
    protected JMXClient client;
    SortedMap<String, Task> map = new TreeMap<String, Task>();

    public CommandReader(JMXClient client, PetalsServer petalsServer) throws PetalsAdminDoesNotExistException, PetalsAdminServiceErrorException, ConnectionErrorException {
        this.currentPath = new File(".");
        File petalsPath = SystemUtil.getPetalsInstallDirectory();
        this.installPath = new File(petalsPath, "install");
        this.installedPath = new File(petalsPath, "installed");
        this.repositoryPath = new File(petalsPath, "repo");
        this.client = client;
        this.petalsService = client.getPetalsAdminServiceClient();
        this.petalsServer = petalsServer;
        this.addCommand(new GetCurrentPathTask(this.currentPath));
        this.addCommand(new HotDeployTask(this.currentPath, this.installPath));
        this.addCommand(new HotUndeployTask(this.installedPath));
        this.addCommand(new InfoTask(this.client, this.petalsServer));
        this.addCommand(new JNDITask(this.petalsServer));
        this.addCommand(new SetPathTask(this.currentPath));
        this.addCommand(new ShutdownTask(this.petalsService));
        this.addCommand(new StopTask(this.petalsService));
        this.addCommand(new GetComponentsTask(this.client));
        this.addCommand(new EndpointListTask(this.petalsServer));
        this.addCommand(new SynchronizeRegistryTask(this.petalsServer));
    }

    private void addCommand(Task command) {
        this.map.put(command.getShortcut(), command);
    }

    public void read() {
        System.out.println("PEtALS prompt. Tape 'help' for help.");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        int code = 1;
        while (code > 0) {
            try {
                System.out.println();
                System.out.print("petals@localhost:/> ");
                code = this.processCommandLine(br.readLine());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected int processCommandLine(String command) {
        int result = 1;
        if (command != null && command.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(command, " ");
            ArrayList<String> args = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                args.add(tokenizer.nextToken());
            }
            String key = (String)args.get(0);
            if ("h".equalsIgnoreCase(key) || "help".equalsIgnoreCase(key)) {
                this.printUsage();
            } else {
                Task task = this.getTask(key);
                if (task == null) {
                    System.out.println("Unrecognized command : " + command + " (type 'h' for help)");
                } else {
                    List arguments = null;
                    arguments = args.size() > 1 ? args.subList(1, args.size()) : new ArrayList(0);
                    result = task.process(arguments);
                    if (result == -2) {
                        System.out.println("Bad arguments : " + arguments + " (type 'h' for help)");
                        result = 1;
                    }
                }
            }
        }
        return result;
    }

    private void printUsage() {
        System.out.println("PEtALS prompt usage:");
        Iterator<String> iter = this.map.keySet().iterator();
        while (iter.hasNext()) {
            Task command = (Task)this.map.get(iter.next());
            System.out.println(" - " + command.toString());
        }
    }

    private Task getTask(String command) {
        String shortcut;
        Task task = (Task)this.map.get(command);
        if (task == null && (shortcut = this.getShortcutFromCommand(command)) != null) {
            task = (Task)this.map.get(shortcut);
        }
        return task;
    }

    private String getShortcutFromCommand(String command) {
        String result = null;
        boolean found = false;
        Iterator<String> iter = this.map.keySet().iterator();
        while (iter.hasNext() && !found) {
            Task task = (Task)this.map.get(iter.next());
            if (!command.equals(task.getName())) continue;
            result = task.getShortcut();
            found = true;
        }
        return result;
    }
}

