/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.monitor.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URI;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.ow2.petals.commons.stream.InputStreamForker;
import org.ow2.petals.commons.stream.ReaderInputStream;
import org.ow2.petals.commons.threadlocal.DocumentBuilders;
import org.ow2.petals.commons.threadlocal.Transformers;
import org.petalslink.dsb.api.DSBException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class MonitoringUtil {
    public static String splitPattern(URI uRI) {
        String[] stringArray = uRI.toString().split("/");
        if (stringArray != null) {
            return stringArray[stringArray.length - 1];
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String cloneSourceInString(Source source) throws DSBException {
        Source source2 = source;
        if (source instanceof StreamSource) {
            source2 = new StreamSource(MonitoringUtil.forkStreamSource((StreamSource)source));
        }
        try {
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            Transformer transformer = Transformers.getDefaultTransformer();
            try {
                transformer.transform(source2, streamResult);
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                transformer.reset();
                throw throwable;
            }
            {
                Object var5_9 = null;
                transformer.reset();
                return stringWriter.toString();
            }
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new DSBException((Throwable)transformerConfigurationException);
        }
        catch (TransformerException transformerException) {
            throw new DSBException((Throwable)transformerException);
        }
    }

    public static Source cloneSource(Source source) throws DSBException {
        Document document = MonitoringUtil.createDocument(source, true);
        return MonitoringUtil.createDOMSource(document);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static StreamSource createStreamSource(Document document) throws DSBException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(byteArrayOutputStream);
        Transformer transformer = Transformers.getDefaultTransformer();
        try {
            try {
                transformer.transform(new DOMSource(document), streamResult);
            }
            catch (TransformerException transformerException) {
                throw new DSBException("Error while transform DOM2 document to StreamSource", (Throwable)transformerException);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            transformer.reset();
            throw throwable;
        }
        {
            Object var5_8 = null;
            transformer.reset();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            return new StreamSource(byteArrayInputStream);
        }
    }

    private static DOMSource createDOMSource(Document document) {
        document.normalizeDocument();
        return new DOMSource(document);
    }

    public static String parseToString(Node node) throws TransformerException, TransformerFactoryConfigurationError {
        String string = null;
        if (node != null) {
            node.normalize();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            StringWriter stringWriter = new StringWriter();
            transformer.transform(new DOMSource(node), new StreamResult(stringWriter));
            StringBuffer stringBuffer = stringWriter.getBuffer();
            string = stringBuffer.toString();
        }
        return string;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Document createDocument(Source source, boolean bl) throws DSBException {
        Document document = null;
        try {
            Object object;
            Object object2;
            if (source instanceof DOMSource) {
                object2 = ((DOMSource)source).getNode();
                if (object2 instanceof Document) {
                    object = (Document)object2;
                    if (bl) {
                        document = DocumentBuilders.getNamespaceDocumentBuilder().newDocument();
                        document.appendChild(document.importNode(object.getDocumentElement(), true));
                    } else {
                        document = object;
                    }
                } else {
                    document = DocumentBuilders.getNamespaceDocumentBuilder().newDocument();
                    if (bl) {
                        document.appendChild(document.importNode((Node)object2, true));
                    } else {
                        document.appendChild(document.adoptNode((Node)object2));
                    }
                }
            }
            if (document != null) return document;
            object2 = source;
            if (bl && source instanceof StreamSource) {
                object2 = new StreamSource(MonitoringUtil.forkStreamSource((StreamSource)source));
            }
            document = DocumentBuilders.getNamespaceDocumentBuilder().newDocument();
            object = new DOMResult(document);
            Transformer transformer = Transformers.getDefaultTransformer();
            try {
                transformer.transform((Source)object2, (Result)object);
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                transformer.reset();
                throw throwable;
            }
            {
                Object var6_9 = null;
                transformer.reset();
                return document;
            }
        }
        catch (TransformerException transformerException) {
            throw new DSBException((Throwable)transformerException);
        }
    }

    private static final InputStream forkStreamSource(StreamSource streamSource) {
        InputStream inputStream = streamSource.getInputStream();
        InputStreamForker inputStreamForker = inputStream != null ? new InputStreamForker(inputStream) : new InputStreamForker((InputStream)new ReaderInputStream(streamSource.getReader()));
        streamSource.setInputStream(inputStreamForker.getInputStreamOne());
        return inputStreamForker.getInputStreamTwo();
    }
}

