/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.monitoring.router;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.container.lifecycle.ServiceUnitLifeCycle;
import org.ow2.petals.jbi.component.context.ComponentContext;
import org.ow2.petals.jbi.messaging.exchange.MessageExchange;
import org.ow2.petals.jbi.messaging.exchange.MessageExchangeImpl;
import org.ow2.petals.jbi.messaging.routing.RouterService;
import org.ow2.petals.jbi.messaging.routing.RoutingException;
import org.ow2.petals.tools.monitoring.to.Role;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.kernel.monitoring.router.MonitoringModule;
import org.petalslink.dsb.kernel.monitoring.router.MonitoringStorageService;
import org.petalslink.dsb.kernel.monitoring.router.RouterMonitorImpl;
import org.petalslink.dsb.kernel.monitoring.util.TOConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=RouterService.class)})
public class MonitoringModuleImpl
extends RouterMonitorImpl
implements BindingController,
LifeCycleController,
MonitoringModule {
    @Requires(name="storageService", signature=MonitoringStorageService.class)
    private MonitoringStorageService storageService;
    private static final int MAX_STORAGE = 1000;

    @Override
    public long getExchangeDuration(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The 'timestamp' parameter must not be null ");
        }
        ExchangeContext exchangeContext = this.storageService.getStorage().get(string);
        if (exchangeContext != null) {
            return exchangeContext.getEndingExchange().getTime() - exchangeContext.getBeginExchange().getTime();
        }
        return 0L;
    }

    @Override
    public String getFcState() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public org.ow2.petals.tools.monitoring.to.MessageExchange getMessageExchange(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("The 'timestamp' parameter must not be null ");
        }
        Map<String, ExchangeContext> map = this.storageService.getStorage();
        synchronized (map) {
            Set<String> set = this.storageService.getStorage().keySet();
            if (set != null) {
                for (String string : set) {
                    ExchangeContext exchangeContext = this.storageService.getStorage().get(string);
                    if (!exchangeContext.getBeginExchange().equals(date)) continue;
                    return exchangeContext.getExchange();
                }
            }
        }
        return null;
    }

    @Override
    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @Override
    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public List<org.ow2.petals.tools.monitoring.to.MessageExchange> getMessageExchange(Date var1_1, Date var2_2) {
        block3: {
            block4: {
                var3_3 = Collections.synchronizedList(new ArrayList<E>());
                var4_4 = this.storageService.getStorage().keySet();
                if (var4_4 == null) break block3;
                var5_5 = var4_4.iterator();
                if (var1_1 != null || var2_2 != null) break block4;
                while (var5_5.hasNext()) {
                    var3_3.add(this.storageService.getStorage().get(var5_5.next()).getExchange());
                }
                break block3;
            }
            if (var1_1 == null) {
                throw new IllegalArgumentException("The 'begin' parameter must not be null if 'ending' parameter is null too ");
            }
            if (var2_2 != null) ** GOTO lbl21
            throw new IllegalArgumentException("The 'ending' parameter must not be null if 'begin' parameter is null too ");
lbl-1000:
            // 1 sources

            {
                var6_6 = var5_5.next();
                var7_7 = this.storageService.getStorage().get(var6_6);
                if (var7_7.getBeginExchange().getTime() <= var1_1.getTime() || var7_7.getEndingExchange().getTime() >= var2_2.getTime()) continue;
                var3_3.add(var7_7.getExchange());
lbl21:
                // 3 sources

                ** while (var5_5.hasNext())
            }
        }
        return var3_3;
    }

    @Override
    public org.ow2.petals.tools.monitoring.to.MessageExchange getMessageExchanges(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The 'exchangeId' parameter must not be null ");
        }
        ExchangeContext exchangeContext = this.storageService.getStorage().get(string);
        if (exchangeContext != null) {
            return exchangeContext.getExchange();
        }
        return null;
    }

    @Override
    public String getConsumer(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The 'exchangeId' parameter must not be null ");
        }
        ExchangeContext exchangeContext = this.storageService.getStorage().get(string);
        if (exchangeContext != null) {
            return exchangeContext.getConsumer();
        }
        return null;
    }

    @Override
    public String getProvider(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The 'exchangeId' parameter must not be null ");
        }
        ExchangeContext exchangeContext = this.storageService.getStorage().get(string);
        if (exchangeContext != null) {
            return exchangeContext.getProvider();
        }
        return null;
    }

    public void removeMessageExchange(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The 'exchangeId' parameter must not be null ");
        }
        this.storageService.getStorage().remove(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeMessageExchange(ComponentContext componentContext, org.ow2.petals.tools.monitoring.to.MessageExchange messageExchange, Date date, Date date2) {
        if (messageExchange == null) {
            throw new IllegalArgumentException("The 'exchange' parameter must not be null ");
        }
        ExchangeContext exchangeContext = new ExchangeContext();
        exchangeContext.setBeginExchange(date);
        exchangeContext.setEndingExchange(date2);
        exchangeContext.setExchange(messageExchange);
        if (messageExchange.getRole().equals(Role.CONSUMER)) {
            exchangeContext.setConsumer(componentContext.getComponentName());
        } else if (messageExchange.getRole().equals(Role.PROVIDER)) {
            exchangeContext.setProvider(componentContext.getComponentName());
        }
        Map<String, ExchangeContext> map = this.storageService.getStorage();
        synchronized (map) {
            if (this.storageService.getStorage().size() == 1000) {
                this.storageService.getStorage().clear();
            }
            this.storageService.getStorage().put(messageExchange.getExchangeId(), exchangeContext);
        }
    }

    public void updateMessageExchange(ComponentContext componentContext, org.ow2.petals.tools.monitoring.to.MessageExchange messageExchange, Date date, Date date2) {
        if (messageExchange == null) {
            throw new IllegalArgumentException("The 'exchange' parameter must not be null ");
        }
        this.removeMessageExchange(messageExchange.getExchangeId());
        this.storeMessageExchange(componentContext, messageExchange, date, date2);
    }

    @Override
    public void addComponent(ComponentContext componentContext) throws RoutingException {
        super.addComponent(componentContext);
    }

    @Override
    public void modifiedSALifeCycle(List<ServiceUnitLifeCycle> list) {
        super.modifiedSALifeCycle(list);
    }

    public MessageExchangeImpl receive(ComponentContext componentContext, long l) throws RoutingException {
        MessageExchangeImpl messageExchangeImpl = (MessageExchangeImpl)this.router.receive(componentContext, l);
        if (messageExchangeImpl != null) {
            System.out.println("***********************");
            System.out.println("[receive]exchange.getFault: " + messageExchangeImpl.getFault());
            System.out.println("[receive]exchange.getOut: " + messageExchangeImpl.getMessage("OUT"));
            System.out.println("***********************");
            this.report(messageExchangeImpl, this.logger, componentContext);
        }
        return messageExchangeImpl;
    }

    @Override
    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("router")) {
            if (!RouterService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + RouterService.class.getName());
            }
            this.router = (RouterService)object;
            return;
        }
        if (string.equals("storageService")) {
            if (!MonitoringStorageService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + MonitoringStorageService.class.getName());
            }
            this.storageService = (MonitoringStorageService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    @Override
    public void removeComponent(ComponentContext componentContext) throws RoutingException {
        super.removeComponent(componentContext);
    }

    public void send(ComponentContext componentContext, MessageExchangeImpl messageExchangeImpl) throws RoutingException {
        if (messageExchangeImpl != null) {
            System.out.println("***********************");
            System.out.println("[send]exchange.getFault: " + messageExchangeImpl.getFault());
            System.out.println("[send]exchange.getOut: " + messageExchangeImpl.getMessage("OUT"));
            System.out.println("***********************");
            this.report(messageExchangeImpl, this.logger, componentContext);
        }
        this.router.send(componentContext, (MessageExchange)messageExchangeImpl);
    }

    @Override
    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("router");
        arrayList.add("storageService");
        return arrayList.toArray(new String[0]);
    }

    public MessageExchangeImpl sendSync(ComponentContext componentContext, MessageExchangeImpl messageExchangeImpl, long l) throws RoutingException {
        System.out.println("***********************");
        System.out.println("[sendSync]avantReport|exchange.getFault: " + messageExchangeImpl.getFault());
        System.out.println("[sendSync]avantReport|exchange.getOut: " + messageExchangeImpl.getMessage("OUT"));
        System.out.println("***********************");
        this.report(messageExchangeImpl, this.logger, componentContext);
        System.out.println("***********************");
        System.out.println("[sendSync]exchange.getFault: " + messageExchangeImpl.getFault());
        System.out.println("[sendSync]exchange.getOut: " + messageExchangeImpl.getMessage("OUT"));
        System.out.println("***********************");
        MessageExchangeImpl messageExchangeImpl2 = (MessageExchangeImpl)this.router.sendSync(componentContext, (MessageExchange)messageExchangeImpl, l);
        if (messageExchangeImpl2 != null) {
            System.out.println("***********************");
            System.out.println("[sendSync]responseExchange.getFault: " + messageExchangeImpl2.getFault());
            System.out.println("[sendSync]responseExchange.getOut: " + messageExchangeImpl2.getMessage("OUT"));
            System.out.println("***********************");
            this.report(messageExchangeImpl2, this.logger, componentContext);
        }
        return messageExchangeImpl2;
    }

    @Override
    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("router")) {
            return this.router;
        }
        if (string.equals("storageService")) {
            return this.storageService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    @Override
    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("router")) {
            this.router = null;
            return;
        }
        if (string.equals("storageService")) {
            this.storageService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    private void report(MessageExchangeImpl messageExchangeImpl, Logger logger, ComponentContext componentContext) {
        org.ow2.petals.tools.monitoring.to.MessageExchange messageExchange = null;
        if (messageExchangeImpl != null) {
            System.out.println("***********************");
            System.out.println("[report]exchange.getFault: " + messageExchangeImpl.getFault());
            System.out.println("[report]exchange.getOut: " + messageExchangeImpl.getMessage("OUT"));
            System.out.println("***********************");
            try {
                messageExchange = TOConverter.convert(messageExchangeImpl, this.logger);
            }
            catch (SecurityException securityException) {
                this.logger.log(20, (Object)("[Error occured during the role conversion in the monitoring module]: " + securityException.getMessage()));
            }
            catch (NoSuchFieldException noSuchFieldException) {
                this.logger.log(20, (Object)("[Error occured during the role conversion in the monitoring module]: " + noSuchFieldException.getMessage()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.logger.log(20, (Object)("[Error occured during the role conversion in the monitoring module]: " + illegalArgumentException.getMessage()));
            }
            catch (IllegalAccessException illegalAccessException) {
                this.logger.log(20, (Object)("[Error occured during the role conversion in the monitoring module]: " + illegalAccessException.getMessage()));
            }
            catch (IOException iOException) {
                this.logger.log(20, (Object)("[Error occured during the role conversion in the monitoring module]: " + iOException.getMessage()));
            }
            catch (RoutingException routingException) {
                this.logger.log(20, (Object)("[Error occured during the role conversion in the monitoring module]: " + routingException.getMessage()));
            }
        }
        if (messageExchange != null) {
            ExchangeContext exchangeContext = this.storageService.getStorage().get(messageExchange.getExchangeId());
            if (exchangeContext != null) {
                this.removeMessageExchange(messageExchange.getExchangeId());
                if (exchangeContext.getExchange().getIn() != null) {
                    messageExchange.setIn(exchangeContext.getExchange().getIn());
                }
                if (exchangeContext.getExchange().getOut() != null) {
                    messageExchange.setOut(exchangeContext.getExchange().getOut());
                }
                if (exchangeContext.getExchange().getFault() != null) {
                    messageExchange.setFault(exchangeContext.getExchange().getFault());
                }
                this.storeMessageExchange(componentContext, messageExchange, Calendar.getInstance().getTime(), null);
            } else {
                this.storeMessageExchange(componentContext, messageExchange, Calendar.getInstance().getTime(), null);
            }
        }
    }

    public void startTraffic() {
    }

    @Override
    public void stopTraffic() {
        super.stopTraffic();
    }

    @Override
    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        super.start();
        this.log = new LoggingUtil(this.logger);
        this.log.call();
    }

    @Override
    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() throws Exception {
        super.stop();
        this.log.call();
    }

    public class ExchangeContext {
        private org.ow2.petals.tools.monitoring.to.MessageExchange exchange;
        private Date beginExchange;
        private Date endingExchange;
        private String provider;
        private String consumer;

        public ExchangeContext(Date date, String string, Date date2, org.ow2.petals.tools.monitoring.to.MessageExchange messageExchange, String string2) {
            this.beginExchange = date;
            this.consumer = string;
            this.endingExchange = date2;
            this.exchange = messageExchange;
            this.provider = string2;
        }

        public ExchangeContext() {
        }

        public org.ow2.petals.tools.monitoring.to.MessageExchange getExchange() {
            return this.exchange;
        }

        public void setExchange(org.ow2.petals.tools.monitoring.to.MessageExchange messageExchange) {
            this.exchange = messageExchange;
        }

        public Date getBeginExchange() {
            return this.beginExchange;
        }

        public void setBeginExchange(Date date) {
            this.beginExchange = date;
        }

        public Date getEndingExchange() {
            return this.endingExchange;
        }

        public void setEndingExchange(Date date) {
            this.endingExchange = date;
        }

        public String getProvider() {
            return this.provider;
        }

        public void setProvider(String string) {
            this.provider = string;
        }

        public String getConsumer() {
            return this.consumer;
        }

        public void setConsumer(String string) {
            this.consumer = string;
        }
    }
}

