/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.monitoring.ws;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.registry.EndpointRegistry;
import org.ow2.petals.jbi.messaging.registry.RegistryException;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.kernel.configuration.ContainerConfiguration;
import org.ow2.petals.tools.monitoring.to.ContainerInformations;
import org.ow2.petals.tools.monitoring.to.MessageExchange;
import org.ow2.petals.tools.monitoring.to.RuntimeInformations;
import org.ow2.petals.tools.monitoring.wsapi.MonitoringException;
import org.ow2.petals.tools.monitoring.wsapi.MonitoringService;
import org.ow2.petals.tools.ws.KernelWebService;
import org.petalslink.dsb.kernel.monitoring.router.MonitoringModuleImpl;
import org.petalslink.dsb.kernel.monitoring.router.MonitoringStorageService;
import org.petalslink.dsb.kernel.monitoring.util.MonitoringUtil;
import org.petalslink.dsb.kernel.monitoring.util.TOConverter;
import org.petalslink.dsb.kernel.monitoring.ws.DistributedMonitoringServiceImpl;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="webservice", signature=MonitoringService.class), @Interface(name="service", signature=KernelWebService.class)})
public class StandaloneMonitoringServiceImpl
implements BindingController,
MonitoringService,
KernelWebService {
    private Component component;
    @Requires(name="configurationService", signature=ConfigurationService.class)
    private ConfigurationService configurationService;
    @Requires(name="storageService", signature=MonitoringStorageService.class)
    private MonitoringStorageService storageService;
    @Requires(name="registryService", signature=EndpointRegistry.class)
    private EndpointRegistry registryService;

    public ContainerInformations getContainerInformations(String string) throws MonitoringException {
        try {
            return this.createContainerInformations(string);
        }
        catch (PetalsException petalsException) {
            throw new MonitoringException((Throwable)petalsException);
        }
    }

    public List<org.ow2.petals.tools.monitoring.to.ServiceEndpoint> getEndpoints(String string) throws MonitoringException {
        ArrayList<org.ow2.petals.tools.monitoring.to.ServiceEndpoint> arrayList = new ArrayList<org.ow2.petals.tools.monitoring.to.ServiceEndpoint>();
        List list = null;
        try {
            list = this.registryService.getEndpoints();
        }
        catch (RegistryException registryException) {
            throw new MonitoringException((Throwable)registryException);
        }
        if (list != null) {
            for (ServiceEndpoint serviceEndpoint : list) {
                org.ow2.petals.tools.monitoring.to.ServiceEndpoint serviceEndpoint2 = TOConverter.convert(serviceEndpoint);
                if (!serviceEndpoint2.getContainerLocation().equals(string) && string != null) continue;
                arrayList.add(serviceEndpoint2);
            }
        }
        return arrayList;
    }

    /*
     * Unable to fully structure code
     */
    public List<MessageExchange> getMessageExchanges(Date var1_1, Date var2_2) {
        block4: {
            block3: {
                var3_3 = new ArrayList<MessageExchange>();
                var4_4 = this.storageService.getStorage().keySet();
                var5_5 = var4_4.iterator();
                if (var1_1 != null || var2_2 != null) break block3;
                while (var5_5.hasNext()) {
                    var3_3.add(this.storageService.getStorage().get(var5_5.next()).getExchange());
                }
                break block4;
            }
            if (var1_1 == null) {
                throw new IllegalArgumentException("The 'begin' parameter must not be null if 'ending' parameter is null too ");
            }
            if (var2_2 != null) ** GOTO lbl20
            throw new IllegalArgumentException("The 'ending' parameter must not be null if 'begin' parameter is null too ");
lbl-1000:
            // 1 sources

            {
                var6_6 = var5_5.next();
                var7_7 = this.storageService.getStorage().get(var6_6);
                if (var7_7.getBeginExchange().getTime() <= var1_1.getTime() || var7_7.getEndingExchange().getTime() >= var2_2.getTime()) continue;
                var3_3.add(var7_7.getExchange());
lbl20:
                // 3 sources

                ** while (var5_5.hasNext())
            }
        }
        return var3_3;
    }

    public RuntimeInformations getRuntimeInformations() {
        return this.createRuntimeInformations();
    }

    public List<String> getServices() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Set<String> set = this.storageService.getStorage().keySet();
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            MonitoringModuleImpl.ExchangeContext exchangeContext = this.storageService.getStorage().get(iterator.next());
            arrayList.add(exchangeContext.getExchange().getService().toString());
        }
        return arrayList;
    }

    public String resolveContainerForEndpoint(String string) throws MonitoringException {
        List list = null;
        try {
            list = this.registryService.getEndpoints();
        }
        catch (RegistryException registryException) {
            throw new MonitoringException((Throwable)registryException);
        }
        if (list != null) {
            for (ServiceEndpoint serviceEndpoint : list) {
                if (!serviceEndpoint.getEndpointName().equals(string)) continue;
                return serviceEndpoint.getLocation().getContainerName();
            }
        }
        return null;
    }

    private ContainerInformations createContainerInformations(String string) throws PetalsException {
        ContainerInformations containerInformations = new ContainerInformations();
        ContainerConfiguration containerConfiguration = this.configurationService.getContainerConfiguration(string);
        containerInformations.setContainerId(string);
        containerInformations.setDaemonThreadCount((long)ManagementFactory.getThreadMXBean().getDaemonThreadCount());
        containerInformations.setDescription(containerConfiguration.getDescription());
        containerInformations.setHeapMemoryUsage(ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed());
        containerInformations.setHost(containerConfiguration.getHost());
        containerInformations.setJmxJNDIPort(Integer.toString(containerConfiguration.getJmxRMIConnectorPort()));
        containerInformations.setObjectPendingFinalizationCount((long)ManagementFactory.getMemoryMXBean().getObjectPendingFinalizationCount());
        containerInformations.setPeakThreadCount((long)ManagementFactory.getThreadMXBean().getPeakThreadCount());
        containerInformations.setStatus(containerConfiguration.getState().toString());
        containerInformations.setTcpPort(Integer.toString(containerConfiguration.getTCPPort()));
        containerInformations.setThreadCount((long)ManagementFactory.getThreadMXBean().getThreadCount());
        containerInformations.setTotalStartedThreadCount(ManagementFactory.getThreadMXBean().getTotalStartedThreadCount());
        containerInformations.setUpTime(ManagementFactory.getRuntimeMXBean().getUptime());
        containerInformations.setVersion(containerConfiguration.getDescription());
        return containerInformations;
    }

    private RuntimeInformations createRuntimeInformations() {
        RuntimeInformations runtimeInformations = new RuntimeInformations();
        runtimeInformations.setAvailableProcessors((long)ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors());
        runtimeInformations.setClassLoading(DistributedMonitoringServiceImpl.class.getClassLoader().getClass().getName());
        runtimeInformations.setFreeMemory(Runtime.getRuntime().freeMemory());
        runtimeInformations.setMaxMemory(Runtime.getRuntime().maxMemory());
        runtimeInformations.setMemory(ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().toString());
        runtimeInformations.setOperationSystem(ManagementFactory.getOperatingSystemMXBean().getName());
        runtimeInformations.setProcessCPUTime(ManagementFactory.getThreadMXBean().getCurrentThreadCpuTime());
        runtimeInformations.setRuntime(ManagementFactory.getRuntimeMXBean().getName());
        runtimeInformations.setThreading(Boolean.toString(ManagementFactory.getThreadMXBean().isCurrentThreadCpuTimeSupported()));
        runtimeInformations.setTotalMemory(Runtime.getRuntime().totalMemory());
        return runtimeInformations;
    }

    public Component getComponent() {
        return this.component;
    }

    public List<String> getAllContainerName() throws MonitoringException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Set set = null;
        set = this.configurationService.getContainersConfiguration();
        if (set != null) {
            for (ContainerConfiguration containerConfiguration : set) {
                arrayList.add(containerConfiguration.getName());
            }
        }
        return arrayList;
    }

    public List<ContainerInformations> getContainersInformations() throws MonitoringException {
        ArrayList<ContainerInformations> arrayList = new ArrayList<ContainerInformations>();
        Set set = null;
        if (set != null) {
            for (ContainerConfiguration containerConfiguration : set) {
                ContainerInformations containerInformations = new ContainerInformations();
                containerInformations.setContainerId(containerConfiguration.getName());
                containerInformations.setDaemonThreadCount((long)ManagementFactory.getThreadMXBean().getDaemonThreadCount());
                containerInformations.setDescription(containerConfiguration.getDescription());
                containerInformations.setHeapMemoryUsage(ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed());
                containerInformations.setHost(containerConfiguration.getHost());
                containerInformations.setJmxJNDIPort(Integer.toString(containerConfiguration.getJmxRMIConnectorPort()));
                containerInformations.setObjectPendingFinalizationCount((long)ManagementFactory.getMemoryMXBean().getObjectPendingFinalizationCount());
                containerInformations.setPeakThreadCount((long)ManagementFactory.getThreadMXBean().getPeakThreadCount());
                containerInformations.setStatus(containerConfiguration.getState().toString());
                containerInformations.setTcpPort(Integer.toString(containerConfiguration.getTCPPort()));
                containerInformations.setThreadCount((long)ManagementFactory.getThreadMXBean().getThreadCount());
                containerInformations.setTotalStartedThreadCount(ManagementFactory.getThreadMXBean().getTotalStartedThreadCount());
                containerInformations.setUpTime(ManagementFactory.getRuntimeMXBean().getUptime());
                containerInformations.setVersion(containerConfiguration.getDescription());
                arrayList.add(containerInformations);
            }
        }
        return arrayList;
    }

    public String getDescriptionEndpoint(String string) throws MonitoringException {
        List list = null;
        try {
            list = this.registryService.getEndpoints();
        }
        catch (RegistryException registryException) {
            throw new MonitoringException((Throwable)registryException);
        }
        if (list != null) {
            for (ServiceEndpoint serviceEndpoint : list) {
                if (!serviceEndpoint.getEndpointName().equals(string)) continue;
                Document document = null;
                try {
                    document = this.registryService.getEndpointDescriptorForEndpoint(serviceEndpoint);
                }
                catch (RegistryException registryException) {
                    throw new MonitoringException((Throwable)registryException);
                }
                if (document == null) continue;
                try {
                    return MonitoringUtil.parseToString(document.cloneNode(true));
                }
                catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
                    throw new MonitoringException((Throwable)transformerFactoryConfigurationError);
                }
                catch (TransformerException transformerException) {
                    throw new MonitoringException((Throwable)transformerException);
                }
            }
        }
        return null;
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("component")) {
            this.component = (Component)object;
            return;
        }
        if (string.equals("configurationService")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        if (string.equals("storageService")) {
            if (!MonitoringStorageService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + MonitoringStorageService.class.getName());
            }
            this.storageService = (MonitoringStorageService)object;
            return;
        }
        if (string.equals("registryService")) {
            if (!EndpointRegistry.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + EndpointRegistry.class.getName());
            }
            this.registryService = (EndpointRegistry)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("configurationService");
        arrayList.add("storageService");
        arrayList.add("registryService");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("configurationService")) {
            return this.configurationService;
        }
        if (string.equals("storageService")) {
            return this.storageService;
        }
        if (string.equals("registryService")) {
            return this.registryService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("configurationService")) {
            this.configurationService = null;
            return;
        }
        if (string.equals("storageService")) {
            this.storageService = null;
            return;
        }
        if (string.equals("registryService")) {
            this.registryService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

