/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.node.manager.client;

import java.util.List;
import java.util.logging.Logger;
import org.petalslink.dsb.api.Node;
import org.petalslink.dsb.node.manager.api.NodeListener;
import org.petalslink.dsb.node.manager.api.Resource;
import org.petalslink.dsb.node.manager.api.ResourceClientFactory;
import org.petalslink.dsb.node.manager.api.ResourceService;

public class EndpointsNodeListener
implements NodeListener {
    private static Logger LOG = Logger.getLogger(EndpointsNodeListener.class.getName());
    private ResourceClientFactory clientFactory;

    public void onJoin(Node node) {
        if (this.clientFactory == null) {
            LOG.warning("Factory is null!");
            return;
        }
        ResourceService client = this.clientFactory.getClient(node);
        List<String> ids = client.all("endoint");
        for (String id : ids) {
            Resource endpoint = client.get(id);
            if (endpoint == null) {
                LOG.info("Null endpoint for id " + id);
                continue;
            }
            LOG.info(" TODO : Got a new endpoint, let's notify the registry");
        }
    }

    public void onLeave(Node node) {
        LOG.info(String.format("TODO : The node %s is leaving, delete all its remaining endpoints...", node));
    }
}

