/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.node.manager.client;

import java.util.List;
import java.util.logging.Logger;
import org.petalslink.dsb.api.Node;
import org.petalslink.dsb.node.manager.api.NodeClientFactory;
import org.petalslink.dsb.node.manager.api.NodeException;
import org.petalslink.dsb.node.manager.api.NodeManager;
import org.petalslink.dsb.node.manager.api.NodeService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagerClient {
    private static Logger LOG = Logger.getLogger(ManagerClient.class.getName());
    private NodeClientFactory factory;
    private NodeManager manager;
    private final Node me;

    public ManagerClient(Node me) {
        this.me = me;
    }

    public void join() throws NodeException {
        LOG.info("Want to join the network...");
        List<Node> remotes = this.manager.join(this.me);
        if (remotes == null || remotes.size() == 0) {
            LOG.fine("Seems that there are no nodes registred on the manager");
            return;
        }
        for (Node node : remotes) {
            LOG.fine(String.format("Telling node '%s' that I am here...", node.getUuid()));
            NodeService client = this.factory.getClient(node);
            client.join(this.me);
        }
    }

    public void leave() throws NodeException {
        LOG.info("Want to leave the network...");
        this.manager.leave(this.me);
    }

    public List<Node> get() {
        LOG.info("Get all current nodes from the manager...");
        return this.manager.get();
    }

    public NodeClientFactory getFactory() {
        return this.factory;
    }

    public void setFactory(NodeClientFactory factory) {
        this.factory = factory;
    }

    public NodeManager getManager() {
        return this.manager;
    }

    public void setManager(NodeManager manager) {
        this.manager = manager;
    }
}

