/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.node.manager.client;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.petalslink.dsb.api.Node;
import org.petalslink.dsb.node.manager.api.NodeListener;

public class NodeService
implements org.petalslink.dsb.node.manager.api.NodeService {
    private static Logger LOG = Logger.getLogger(NodeService.class.getName());
    private NodeListener listener;
    private Map<String, Node> nodes = new HashMap<String, Node>();

    public void join(Node node) {
        LOG.info("There is a new node joining us!");
        if (node == null) {
            return;
        }
        this.nodes.put(node.getUuid(), node);
        if (this.listener != null) {
            this.listener.onJoin(node);
        }
    }

    public void leave(Node node) {
        LOG.info("There is a node leaving us!");
        if (node == null) {
            return;
        }
        this.nodes.remove(node.getUuid());
        if (this.listener != null) {
            this.listener.onLeave(node);
        }
    }

    public NodeListener getListener() {
        return this.listener;
    }

    public void setListener(NodeListener listener) {
        this.listener = listener;
    }
}

