/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.node.manager.client;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.petalslink.dsb.api.Node;
import org.petalslink.dsb.node.manager.api.Resource;
import org.petalslink.dsb.node.manager.api.ResourceClientFactory;
import org.petalslink.dsb.node.manager.api.ResourceListener;
import org.petalslink.dsb.node.manager.common.ResourceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceService
implements org.petalslink.dsb.node.manager.api.ResourceService {
    private static Logger LOG = Logger.getLogger(ResourceService.class.getName());
    private ResourceClientFactory factory;
    private ResourceListener resourceListener;
    private Map<String, org.petalslink.dsb.node.manager.api.ResourceService> resourceTypeResolver = new HashMap<String, org.petalslink.dsb.node.manager.api.ResourceService>();
    private Map<String, Resource> resourcesCache = new HashMap<String, Resource>();

    @Override
    public void add(String id) {
        Node node = this.getNode(id);
        if (this.factory == null) {
            return;
        }
        org.petalslink.dsb.node.manager.api.ResourceService client = this.factory.getClient(node);
        Resource resource = client.get(id);
        if (resource == null) {
            return;
        }
        this.resourcesCache.put(id, resource);
        if (this.resourceListener != null) {
            this.resourceListener.onNew(resource);
        }
    }

    private Node getNode(String id) {
        Node n = new Node();
        try {
            URL url = URI.create(id).toURL();
            n.setUuid(url.getProtocol() + "://" + url.getHost() + ":" + url.getPort());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return n;
    }

    @Override
    public void remove(String id) {
    }

    @Override
    public Resource get(String id) {
        org.petalslink.dsb.node.manager.api.ResourceService resolver = this.resourceTypeResolver.get(ResourceResolver.getType(id));
        if (resolver != null) {
            return resolver.get(id);
        }
        return null;
    }

    @Override
    public List<String> all(String type) {
        org.petalslink.dsb.node.manager.api.ResourceService resolver = this.resourceTypeResolver.get(type);
        if (resolver != null) {
            return resolver.all(type);
        }
        return null;
    }

    public ResourceClientFactory getFactory() {
        return this.factory;
    }

    public void setFactory(ResourceClientFactory factory) {
        this.factory = factory;
    }

    public ResourceListener getResourceListener() {
        return this.resourceListener;
    }

    public void setResourceListener(ResourceListener resourceListener) {
        this.resourceListener = resourceListener;
    }

    public Map<String, org.petalslink.dsb.node.manager.api.ResourceService> getResourceTypeResolver() {
        return this.resourceTypeResolver;
    }
}

