/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.node.manager.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.petalslink.dsb.api.Node;
import org.petalslink.dsb.node.manager.api.NodeException;
import org.petalslink.dsb.node.manager.api.NodeListener;
import org.petalslink.dsb.node.manager.api.NodeManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeManagerService
implements NodeManager {
    private static Logger LOG = Logger.getLogger(NodeManagerService.class.getName());
    Map<String, Node> nodes;
    NodeListener nodeListener;
    private final Node me;
    private Object s = new Object();

    public NodeManagerService(Node me) {
        this.me = me;
        this.nodes = new HashMap<String, Node>();
    }

    @Override
    public List<Node> get() {
        return new ArrayList<Node>(this.nodes.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized List<Node> join(Node node) throws NodeException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(String.format("Node '%s' is trying to join", node));
        }
        if (node == null) {
            throw new NodeException("Node is null");
        }
        ArrayList<Node> result = null;
        Object object = this.s;
        synchronized (object) {
            result = new ArrayList<Node>(this.nodes.values());
            this.nodes.put(node.getUuid(), node);
        }
        if (this.nodeListener != null) {
            this.nodeListener.onJoin(node);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void leave(Node node) throws NodeException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(String.format("Node '%s' is trying to leave", node));
        }
        if (node == null) {
            throw new NodeException("Node is null");
        }
        Object object = this.s;
        synchronized (object) {
            this.nodes.remove(node.getUuid());
        }
        if (this.nodeListener != null) {
            this.nodeListener.onLeave(node);
        }
    }

    public NodeListener getNodeListener() {
        return this.nodeListener;
    }

    public void setNodeListener(NodeListener nodeListener) {
        this.nodeListener = nodeListener;
    }
}

