/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.node.manager.server;

import java.util.logging.Logger;
import org.petalslink.dsb.api.Node;
import org.petalslink.dsb.node.manager.api.NodeClientFactory;
import org.petalslink.dsb.node.manager.api.NodeListener;
import org.petalslink.dsb.node.manager.api.NodeManager;
import org.petalslink.dsb.node.manager.api.NodeService;

public class NotifyNodeGroup
implements NodeListener {
    private static Logger LOG = Logger.getLogger(NotifyNodeGroup.class.getName());
    private NodeManager nodeManager;
    private NodeClientFactory factory;

    public void onJoin(Node node) {
        LOG.fine("There is a new node...");
        for (Node n : this.nodeManager.get()) {
            if (n == node) continue;
            LOG.fine("Telling " + n.getUuid() + " that there is a new node");
            NodeService nodeClient = this.factory.getClient(n);
            nodeClient.join(node);
        }
    }

    public void onLeave(Node node) {
        for (Node n : this.nodeManager.get()) {
            if (n == node) continue;
            NodeService nodeClient = this.factory.getClient(n);
            nodeClient.leave(node);
        }
    }

    public NodeManager getNodeManager() {
        return this.nodeManager;
    }

    public void setNodeManager(NodeManager nodeManager) {
        this.nodeManager = nodeManager;
    }

    public NodeClientFactory getFactory() {
        return this.factory;
    }

    public void setFactory(NodeClientFactory factory) {
        this.factory = factory;
    }
}

