/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.notification.commons;

import com.ebmwebsourcing.wsaddressing10.api.element.Address;
import com.ebmwebsourcing.wsaddressing10.api.element.ReferenceParameters;
import com.ebmwebsourcing.wsaddressing10.api.type.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.FilterType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.NotificationMessageHolderType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.TopicExpressionType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.refinedabstraction.RefinedWsnbFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import java.net.URI;
import javax.xml.namespace.QName;
import org.petalslink.dsb.notification.commons.NotificationException;
import org.petalslink.dsb.notification.commons.SOAUtil;
import org.w3c.dom.Document;

public class NotificationHelper {
    public static TopicExpressionType createTopicExpression(QName topicUsed, String dialect) throws NotificationException {
        TopicExpressionType notifyTopicExpr = null;
        try {
            notifyTopicExpr = RefinedWsnbFactory.getInstance().createTopicExpressionType(URI.create(dialect));
            if (topicUsed.getPrefix() == null) {
                throw new NotificationException("prefix of topicUsed cannot be null");
            }
            notifyTopicExpr.addTopicNamespace(topicUsed.getPrefix(), URI.create(topicUsed.getNamespaceURI()));
            notifyTopicExpr.setContent(String.valueOf(topicUsed.getPrefix()) + ":" + topicUsed.getLocalPart());
        }
        catch (WsnbException e) {
            throw new NotificationException(e);
        }
        return notifyTopicExpr;
    }

    public static Notify createNotification(String producerAddress, String endpointAddress, String uuid, QName topicUsed, String dialect, Document notifPayload) throws NotificationException {
        Notify notifyPayload = null;
        try {
            Address address;
            NotificationMessageHolderType.Message mess = null;
            mess = notifPayload != null ? RefinedWsnbFactory.getInstance().createNotificationMessageHolderTypeMessage(notifPayload.getDocumentElement()) : RefinedWsnbFactory.getInstance().createNotificationMessageHolderTypeMessage(null);
            NotificationMessageHolderType msg = RefinedWsnbFactory.getInstance().createNotificationMessageHolderType(mess);
            notifyPayload = RefinedWsnbFactory.getInstance().createNotify(msg);
            if (topicUsed != null) {
                TopicExpressionType notifyTopicExpr = NotificationHelper.createTopicExpression(topicUsed, dialect);
                msg.setTopic(notifyTopicExpr);
            }
            if (endpointAddress != null) {
                EndpointReferenceType registrationRef = (EndpointReferenceType)SOAUtil.getInstance().getXmlObjectFactory().create(EndpointReferenceType.class);
                address = (Address)SOAUtil.getInstance().getXmlObjectFactory().create(Address.class);
                address.setValue(URI.create(endpointAddress));
                registrationRef.setAddress(address);
                ReferenceParameters ref = (ReferenceParameters)SOAUtil.getInstance().getXmlObjectFactory().create(ReferenceParameters.class);
                registrationRef.setReferenceParameters(ref);
                msg.setSubscriptionReference(registrationRef);
            }
            if (producerAddress != null) {
                EndpointReferenceType producerRef = (EndpointReferenceType)SOAUtil.getInstance().getXmlObjectFactory().create(EndpointReferenceType.class);
                address = (Address)SOAUtil.getInstance().getXmlObjectFactory().create(Address.class);
                address.setValue(URI.create(producerAddress));
                producerRef.setAddress(address);
                msg.setProducerReference(producerRef);
            }
            notifyPayload.addNotificationMessage(msg);
        }
        catch (WsnbException e) {
            throw new NotificationException(e);
        }
        return notifyPayload;
    }

    public static Subscribe createSubscribe(String consumerReference, QName topic) throws NotificationException {
        Subscribe result = null;
        EndpointReferenceType consumerRef = (EndpointReferenceType)SOAUtil.getInstance().getXmlObjectFactory().create(EndpointReferenceType.class);
        Address address = (Address)SOAUtil.getInstance().getXmlObjectFactory().create(Address.class);
        address.setValue(URI.create(consumerReference));
        consumerRef.setAddress(address);
        try {
            result = RefinedWsnbFactory.getInstance().createSubscribe(consumerRef);
            FilterType filter = RefinedWsnbFactory.getInstance().createFilterType();
            TopicExpressionType topicExpression = NotificationHelper.createTopicExpression(topic, "http://www.w3.org/TR/1999/REC-xpath-19991116");
            filter.addTopicExpression(topicExpression);
            result.setFilter(filter);
        }
        catch (WsnbException e) {
            throw new NotificationException(e);
        }
        return result;
    }
}

