/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.monitoring.router;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.ow2.petals.commons.stream.InputStreamForker;
import org.ow2.petals.jbi.messaging.exchange.MessageExchange;
import org.ow2.petals.monitoring.router.ExchangeStateCapture;
import org.ow2.petals.monitoring.router.MonitoringMBean;
import org.ow2.petals.monitoring.router.MonitoringThread;
import org.ow2.petals.monitoring.router.RouterMonitor;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Monitoring
implements NotificationBroadcaster,
MonitoringMBean {
    private static final String NEW_MSG_NOTIF_TYPE = "petals.notif.newMsg";
    private static int sequenceNumber = 0;
    protected RouterMonitor routerMonitor;
    NotificationBroadcasterSupport notifSupport = new NotificationBroadcasterSupport();
    private int messagesThreshold = 50;
    private final List<Map<String, Object>> messages = Collections.synchronizedList(new ArrayList(this.messagesThreshold));
    private int timeSendLimit = 10000;
    private MonitoringThread monitoringThread = new MonitoringThread(this);
    private static final ThreadLocal<Transformer> transformerWithoutXmlDeclarationThreadLocal = new ThreadLocal<Transformer>(){

        @Override
        protected Transformer initialValue() {
            try {
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                Properties properties = new Properties();
                properties.put("omit-xml-declaration", "yes");
                transformer.setOutputProperties(properties);
                return transformer;
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                throw new RuntimeException("Failed to create Transformer", transformerConfigurationException);
            }
        }
    };

    @Override
    public void activateMonitoring(boolean bl) {
        if (this.routerMonitor != null) {
            if (!this.routerMonitor.isMonitoring()) {
                this.routerMonitor.activateMonitoring(bl);
                this.startMonitoringThread();
            } else {
                this.routerMonitor.showMessageContent(bl);
            }
        }
    }

    @Override
    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws IllegalArgumentException {
        this.notifSupport.addNotificationListener(notificationListener, notificationFilter, object);
    }

    @Override
    public void deactivateMonitoring() {
        if (this.routerMonitor != null) {
            if (this.routerMonitor.isMonitoring()) {
                this.routerMonitor.deactivateMonitoring();
            }
            this.stopMonitoringThread();
        }
    }

    @Override
    public int getMessagesThreshold() {
        return this.messagesThreshold;
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] stringArray = new String[]{NEW_MSG_NOTIF_TYPE};
        String string = Notification.class.getName();
        String string2 = "Notification containing a list of new messages : HashMap{(String) id, (long) time,(String) component, (String) mep, (String) exception-stacktrace,(String) role, (String) type, (String) status, (String) content, (String serviceName, (String) endpointName, (String) operation}";
        MBeanNotificationInfo mBeanNotificationInfo = new MBeanNotificationInfo(stringArray, string, string2);
        return new MBeanNotificationInfo[]{mBeanNotificationInfo};
    }

    public RouterMonitor getRouterMonitor() {
        return this.routerMonitor;
    }

    @Override
    public int getTimeSendLimit() {
        return this.timeSendLimit;
    }

    @Override
    public boolean isMessageContentShown() {
        return this.routerMonitor.isMessageContentShown();
    }

    @Override
    public boolean isMonitoring() {
        return this.routerMonitor.isMonitoring();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyMessages() {
        if (this.monitoringThread != null) {
            this.restartMonitoringThread();
        }
        Notification notification = null;
        List<Map<String, Object>> list = this.messages;
        synchronized (list) {
            if (this.messages.size() > 0) {
                try {
                    notification = new Notification(NEW_MSG_NOTIF_TYPE, (Object)new ObjectName("Petals:name=Monitoring,type=service"), (long)sequenceNumber++, String.valueOf(this.messages.size()) + " new messages coming");
                    notification.setUserData(new ArrayList<Map<String, Object>>(this.messages));
                    this.messages.clear();
                }
                catch (MalformedObjectNameException malformedObjectNameException) {
                    malformedObjectNameException.printStackTrace();
                }
            }
        }
        if (notification != null) {
            this.notifSupport.sendNotification(notification);
        }
    }

    @Override
    public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        this.notifSupport.removeNotificationListener(notificationListener);
    }

    @Override
    public void setMessagesThreshold(int n) {
        this.messagesThreshold = n;
    }

    public void setRouterMonitor(RouterMonitor routerMonitor) {
        this.routerMonitor = routerMonitor;
    }

    @Override
    public void setTimeSendLimit(int n) {
        this.timeSendLimit = n;
        if (this.monitoringThread != null) {
            this.monitoringThread.setSendingFrequency(this.timeSendLimit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(String string, MessageExchange messageExchange, boolean bl) {
        Map<String, Object> map = Monitoring.messageToRaw(string, messageExchange, bl);
        this.messages.add(map);
        List<Map<String, Object>> list = this.messages;
        synchronized (list) {
            if (this.messages.size() >= this.messagesThreshold) {
                this.notifyMessages();
            }
        }
    }

    protected MonitoringThread getMonitoringThread() {
        return this.monitoringThread;
    }

    protected void restartMonitoringThread() {
        if (this.monitoringThread != null) {
            this.monitoringThread.setSkipNextWakeUp(true);
        }
    }

    protected void setMonitoringThread(MonitoringThread monitoringThread) {
        this.monitoringThread = monitoringThread;
    }

    private void startMonitoringThread() {
        if (this.monitoringThread == null) {
            this.monitoringThread = new MonitoringThread(this);
        }
        this.monitoringThread.start();
    }

    private void stopMonitoringThread() {
        this.monitoringThread.interrupt();
        this.monitoringThread = null;
    }

    private static Map<String, Object> captureToRaw(String string, ExchangeStateCapture exchangeStateCapture) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("id", string);
        hashMap.put("time", exchangeStateCapture.time);
        hashMap.put("component", exchangeStateCapture.component);
        hashMap.put("role", Monitoring.roleToRaw(exchangeStateCapture.role));
        hashMap.put("type", exchangeStateCapture.messageType);
        hashMap.put("status", Monitoring.statusToRaw(exchangeStateCapture.status));
        hashMap.put("content", exchangeStateCapture.content);
        hashMap.put("mep", Monitoring.mepToRaw(exchangeStateCapture.mep));
        hashMap.put("exception", Monitoring.exceptionToRaw(exchangeStateCapture.exception));
        hashMap.put("serviceName", exchangeStateCapture.serviceName == null ? "UndefSvc" : exchangeStateCapture.serviceName.toString());
        hashMap.put("endpointName", exchangeStateCapture.endpointName == null ? "UndefEndpoint" : exchangeStateCapture.endpointName);
        hashMap.put("operation", exchangeStateCapture.operation == null ? "UndefOp" : exchangeStateCapture.operation.toString());
        hashMap.put("container", exchangeStateCapture.container);
        return hashMap;
    }

    private static Source createSource(String string) throws IOException {
        StreamSource streamSource = new StreamSource();
        byte[] byArray = string.getBytes("UTF-8");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        streamSource.setInputStream(byteArrayInputStream);
        return streamSource;
    }

    private static String createString(Source source) throws Exception {
        String string = null;
        try {
            if (source instanceof StreamSource && ((StreamSource)source).getInputStream() != null) {
                StreamSource streamSource = (StreamSource)source;
                InputStreamForker inputStreamForker = new InputStreamForker(streamSource.getInputStream());
                InputStream inputStream = inputStreamForker.getInputStreamOne();
                streamSource.setInputStream(inputStreamForker.getInputStreamTwo());
                byte[] byArray = new byte[inputStream.available()];
                BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                bufferedInputStream.read(byArray);
                string = new String(byArray);
            } else {
                StringWriter stringWriter = new StringWriter();
                StreamResult streamResult = new StreamResult(stringWriter);
                transformerWithoutXmlDeclarationThreadLocal.get().transform(source, streamResult);
                string = stringWriter.toString();
            }
        }
        catch (IOException iOException) {
            throw new Exception(iOException);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new Exception(transformerConfigurationException);
        }
        catch (TransformerException transformerException) {
            throw new Exception(transformerException);
        }
        return string;
    }

    public static ExchangeStateCapture messageToCapture(MessageExchange messageExchange, boolean bl) {
        ExchangeStateCapture exchangeStateCapture = new ExchangeStateCapture();
        exchangeStateCapture.time = System.currentTimeMillis();
        exchangeStateCapture.status = messageExchange.getStatus();
        exchangeStateCapture.role = messageExchange.getRole();
        exchangeStateCapture.mep = messageExchange.getPattern();
        exchangeStateCapture.exception = messageExchange.getError();
        exchangeStateCapture.operation = messageExchange.getOperation();
        if (MessageExchange.Role.CONSUMER.equals(exchangeStateCapture.role)) {
            exchangeStateCapture.component = messageExchange.getConsumerEndpoint().getLocation().getComponentName();
            exchangeStateCapture.container = messageExchange.getConsumerEndpoint().getLocation().getContainerName();
            exchangeStateCapture.serviceName = messageExchange.getConsumerEndpoint().getServiceName();
            exchangeStateCapture.endpointName = messageExchange.getConsumerEndpoint().getEndpointName();
        } else {
            exchangeStateCapture.serviceName = messageExchange.getEndpoint().getServiceName();
            exchangeStateCapture.endpointName = messageExchange.getEndpoint().getEndpointName();
        }
        if (ExchangeStatus.ACTIVE.equals(messageExchange.getStatus())) {
            if (messageExchange.getFault() != null) {
                Fault fault = messageExchange.getFault();
                exchangeStateCapture.messageType = "fault";
                if (bl && fault.getContent() != null) {
                    try {
                        Source source = fault.getContent();
                        Source source2 = null;
                        Source source3 = null;
                        if (source instanceof StreamSource) {
                            InputStreamForker inputStreamForker = new InputStreamForker(((StreamSource)source).getInputStream());
                            source2 = new StreamSource(inputStreamForker.getInputStreamOne());
                            source3 = new StreamSource(inputStreamForker.getInputStreamTwo());
                            fault.setContent(source2);
                        } else if (source instanceof DOMSource) {
                            Document document = (Document)((DOMSource)source).getNode();
                            source2 = new DOMSource(document);
                            source3 = new DOMSource(document);
                            fault.setContent(source2);
                        }
                        exchangeStateCapture.content = Monitoring.createString(source3);
                    }
                    catch (Exception exception) {
                        exchangeStateCapture.content = "<monitoring-error>Error occured while getting fault content</monitoring-error>";
                    }
                    try {
                        fault.setContent(Monitoring.createSource(exchangeStateCapture.content));
                    }
                    catch (MessagingException messagingException) {
                        messagingException.printStackTrace();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            } else {
                Map map = messageExchange.getMessages();
                if (map != null && map.size() > 0) {
                    NormalizedMessage normalizedMessage;
                    if (map.get("out") != null) {
                        normalizedMessage = (NormalizedMessage)map.get("out");
                        exchangeStateCapture.messageType = "out";
                    } else {
                        exchangeStateCapture.messageType = (String)map.keySet().iterator().next();
                        normalizedMessage = (NormalizedMessage)map.get(exchangeStateCapture.messageType);
                    }
                    if (bl && normalizedMessage.getContent() != null) {
                        try {
                            Source source = null;
                            Source source4 = null;
                            if (normalizedMessage.getContent() instanceof StreamSource) {
                                InputStreamForker inputStreamForker = new InputStreamForker(((StreamSource)normalizedMessage.getContent()).getInputStream());
                                source = new StreamSource(inputStreamForker.getInputStreamOne());
                                source4 = new StreamSource(inputStreamForker.getInputStreamTwo());
                                normalizedMessage.setContent(source);
                            } else if (normalizedMessage.getContent() instanceof DOMSource) {
                                Document document = (Document)((DOMSource)normalizedMessage.getContent()).getNode();
                                source = new DOMSource(document);
                                source4 = new DOMSource(document);
                                normalizedMessage.setContent(source);
                            }
                            exchangeStateCapture.content = Monitoring.createString(source4);
                        }
                        catch (Exception exception) {
                            exchangeStateCapture.content = "<monitoring-error>Error occured while getting message content</monitoring-error>";
                        }
                    }
                }
            }
        }
        return exchangeStateCapture;
    }

    private static Map<String, Object> messageToRaw(String string, MessageExchange messageExchange, boolean bl) {
        return Monitoring.captureToRaw(string, Monitoring.messageToCapture(messageExchange, bl));
    }

    protected static String roleToRaw(MessageExchange.Role role) {
        return MessageExchange.Role.CONSUMER.equals(role) ? "consumer" : "provider";
    }

    protected static String exceptionToRaw(Exception exception) {
        String string = null;
        if (exception != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
            exception.printStackTrace(printWriter);
            printWriter.flush();
            string = byteArrayOutputStream.toString();
        }
        return string;
    }

    protected static String mepToRaw(URI uRI) {
        String string = MessageExchange.IN_ONLY_PATTERN.equals(uRI) ? "InOnly" : (MessageExchange.ROBUST_IN_ONLY_PATTERN.equals(uRI) ? "RobustInOnly" : (MessageExchange.IN_OUT_PATTERN.equals(uRI) ? "InOut" : (MessageExchange.IN_OPTIONAL_OUT_PATTERN.equals(uRI) ? "InOptionalOut" : "unknown")));
        return string;
    }

    protected static String statusToRaw(ExchangeStatus exchangeStatus) {
        return ExchangeStatus.DONE.equals(exchangeStatus) ? "done" : (ExchangeStatus.ACTIVE.equals(exchangeStatus) ? "active" : "error");
    }
}

