/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.monitoring.router;

import org.ow2.petals.monitoring.router.Monitoring;

public class MonitoringThread
extends Thread {
    private int SENDING_FREQUENCY = 10000;
    private Monitoring monitor;
    private boolean skipNextWakeUp;

    public MonitoringThread(Monitoring monitoring) {
        this.monitor = monitoring;
        this.SENDING_FREQUENCY = monitoring.getTimeSendLimit();
        this.skipNextWakeUp = false;
        this.setDaemon(true);
    }

    public int getSendingFrequency() {
        return this.SENDING_FREQUENCY;
    }

    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                Thread.sleep(this.SENDING_FREQUENCY);
                if (!this.skipNextWakeUp) {
                    this.monitor.notifyMessages();
                    continue;
                }
                this.skipNextWakeUp = false;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void setSendingFrequency(int n) {
        this.SENDING_FREQUENCY = n;
    }

    public boolean isSkipNextWakeUp() {
        return this.skipNextWakeUp;
    }

    public void setSkipNextWakeUp(boolean bl) {
        this.skipNextWakeUp = bl;
    }
}

