/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.router;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.petalslink.dsb.api.DSBException;
import org.petalslink.dsb.api.MessageExchange;
import org.petalslink.dsb.api.ServiceEndpoint;
import org.petalslink.dsb.kernel.api.router.Router;
import org.petalslink.dsb.kernel.api.router.RouterModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouterImpl
implements Router {
    private Map<String, RouterModule> modules = new ConcurrentHashMap<String, RouterModule>();

    public RouterModule getModule(String name) {
        return this.modules.get(name);
    }

    public void addModule(RouterModule module) {
        if (module != null) {
            this.modules.put(module.getName(), module);
        }
    }

    public RouterModule deleteModule(String name) {
        if (name == null) {
            return null;
        }
        return this.modules.remove(name);
    }

    public List<ServiceEndpoint> route(MessageExchange message) {
        ArrayList<ServiceEndpoint> result = new ArrayList<ServiceEndpoint>();
        for (RouterModule module : this.modules.values()) {
            try {
                result.addAll(module.route(message));
            }
            catch (DSBException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public String getName() {
        return "router";
    }
}

