/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.saaj.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.DOMBuilder;
import org.jdom.output.DOMOutputter;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class SOAPMessageUtils {
    static DocumentBuilder builder;
    static MessageFactory messageFactory;
    private static Logger logger;

    static {
        logger = Logger.getLogger(SOAPMessageUtils.class.getName());
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            messageFactory = MessageFactory.newInstance();
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SOAPException e) {
            e.printStackTrace();
        }
    }

    private SOAPMessageUtils() throws SOAPException {
    }

    public static org.w3c.dom.Document getBodyFromMessage(SOAPMessage message) throws SOAPException {
        Node soapBody;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("SOAPMessage: \n " + SOAPMessageUtils.getSOAPMessageAsString(message));
        }
        if (message == null) {
            throw new SOAPException("Can not get body from null message...");
        }
        SOAPMessageUtils.containsFault(message);
        org.w3c.dom.Document result = builder.newDocument();
        try {
            soapBody = result.importNode(SOAPMessageUtils.getBodyContent(message.getSOAPBody()), true);
        }
        catch (SOAPException e) {
            throw new SOAPException((Throwable)e);
        }
        result.appendChild(soapBody);
        return result;
    }

    public static SOAPMessage createSOAPMessageFromBodyContent(org.w3c.dom.Document bodyDocument) throws SOAPException {
        org.w3c.dom.Document message = null;
        try {
            message = SOAPMessageUtils.createSOAPMessageDocumentFromBodyContent(bodyDocument);
        }
        catch (JDOMException e) {
            throw new SOAPException((Throwable)e);
        }
        return SOAPMessageUtils.buildSOAPMessage(message, messageFactory);
    }

    public static SOAPMessage buildSOAPMessage(InputStream input, MessageFactory messageFactory) {
        SOAPMessage soapMessage = null;
        try {
            soapMessage = messageFactory.createMessage();
            SOAPPart soapPart = soapMessage.getSOAPPart();
            StreamSource preppedMsgSrc = new StreamSource(input);
            soapPart.setContent((Source)preppedMsgSrc);
            soapMessage.saveChanges();
        }
        catch (SOAPException ex) {
            ex.printStackTrace();
        }
        return soapMessage;
    }

    public static SOAPMessage buildSOAPMessage(org.w3c.dom.Document soapMessageAsDocument, MessageFactory messageFactory) {
        try {
            return SOAPMessageUtils.buildSOAPMessage(SOAPMessageUtils.convertDOMSource2InputSource(new DOMSource(soapMessageAsDocument)).getByteStream(), messageFactory);
        }
        catch (SOAPException sOAPException) {
            return null;
        }
    }

    public static SOAPMessage buildSOAPMessage(org.w3c.dom.Document soapMessageAsDocument) {
        try {
            return SOAPMessageUtils.buildSOAPMessage(SOAPMessageUtils.convertDOMSource2InputSource(new DOMSource(soapMessageAsDocument)).getByteStream(), messageFactory);
        }
        catch (SOAPException sOAPException) {
            return null;
        }
    }

    public static byte[] getSOAPMessageAsBytes(SOAPMessage message) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try {
            message.writeTo((OutputStream)byteStream);
        }
        catch (SOAPException sOAPException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteStream.toByteArray();
    }

    public static String getSOAPMessageAsString(SOAPMessage message) {
        return new String(SOAPMessageUtils.getSOAPMessageAsBytes(message));
    }

    public static Node getBodyContent(SOAPBody body) {
        Iterator iterator = body.getChildElements();
        Node firstNode = null;
        while (iterator.hasNext()) {
            Node currentNode = (Node)iterator.next();
            if (!(currentNode instanceof SOAPBodyElement)) continue;
            firstNode = currentNode;
            break;
        }
        return firstNode;
    }

    public static boolean containsFault(SOAPMessage soapMessage) {
        boolean result = false;
        try {
            result = soapMessage.getSOAPBody().getFault() != null;
        }
        catch (SOAPException sOAPException) {
            // empty catch block
        }
        return result;
    }

    private static InputSource convertDOMSource2InputSource(DOMSource domSource) throws SOAPException {
        InputSource source = null;
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            StreamResult streamResult = new StreamResult(os);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(domSource, streamResult);
            os.flush();
            os.close();
            ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
            StreamSource attach = new StreamSource(is);
            source = SAXSource.sourceToInputSource(attach);
        }
        catch (IOException e) {
            throw new SOAPException((Throwable)e);
        }
        catch (TransformerConfigurationException e) {
            throw new SOAPException((Throwable)e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new SOAPException((Throwable)e);
        }
        catch (TransformerException e) {
            throw new SOAPException((Throwable)e);
        }
        return source;
    }

    public static org.w3c.dom.Document createSOAPMessageDocumentFromBodyContent(org.w3c.dom.Document bodyContent) throws JDOMException {
        org.w3c.dom.Document res = null;
        Element env = new Element("Envelope", Namespace.getNamespace((String)"soap-env", (String)"http://schemas.xmlsoap.org/soap/envelope/"));
        env.addNamespaceDeclaration(Namespace.getNamespace((String)"xsd", (String)"http://www.w3.org/1999/XMLSchema"));
        env.addNamespaceDeclaration(Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/1999/XMLSchema-instance"));
        Document jdom = new Document(env);
        Element body = new Element("Body", Namespace.getNamespace((String)"soap-env", (String)"http://schemas.xmlsoap.org/soap/envelope/"));
        env.addContent((Content)body);
        if (bodyContent != null) {
            DOMBuilder builder = new DOMBuilder();
            Document jdomDocument = builder.build(bodyContent);
            body.addContent(((Element)jdomDocument.getRootElement().clone()).detach());
        }
        DOMOutputter converter = new DOMOutputter();
        res = converter.output(jdom);
        return res;
    }

    public static String getOperation(SOAPMessage request) {
        if (request == null) {
            return null;
        }
        MimeHeaders hd = request.getMimeHeaders();
        Iterator iter = hd.getAllHeaders();
        while (iter.hasNext()) {
            MimeHeader object = (MimeHeader)iter.next();
            System.out.println(String.valueOf(object.getName()) + " " + object.getValue());
        }
        String result = null;
        String[] hds = hd.getHeader("SOAPAction");
        if (hds != null && hds.length > 0) {
            result = hds[0];
        }
        return result;
    }
}

