/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.wsnb.services.impl.wsresources;

import com.ebmwebsourcing.wsaddressing10.api.element.Address;
import com.ebmwebsourcing.wsaddressing10.api.element.EndpointReference;
import com.ebmwebsourcing.wsaddressing10.api.element.ReferenceParameters;
import com.ebmwebsourcing.wsaddressing10.api.type.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.api.utils.WsrfbfException;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.WsnbConstants;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.FilterType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.NotificationMessageHolderType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.SubscriptionManagerRP;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.SubscriptionPolicyType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.TopicExpressionType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.refinedabstraction.RefinedWsnbFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbFaultMessageContentConstants;
import com.ebmwebsourcing.wsstar.resource.datatypes.api.utils.WsrfrException;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.abstraction.CurrentTime;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.abstraction.Destroy;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.abstraction.DestroyResponse;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.abstraction.ScheduledResourceTerminationRP;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.abstraction.SetTerminationTime;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.abstraction.SetTerminationTimeResponse;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.abstraction.TerminationNotification;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.abstraction.TerminationTime;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.refinedabstraction.RefinedWsrfrlFactory;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.utils.WsrfrlException;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.WstopConstants;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.utils.SOAUtil;
import com.ebmwebsourcing.wsstar.wsnb.services.faults.UnacceptableInitialTerminationTimeFault;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import com.ebmwebsourcing.wsstar.wsnb.services.transport.ITransporterForWsnbPublisher;
import com.ebmwebsourcing.wsstar.wsrfbf.services.faults.AbsWSStarFault;
import com.ebmwebsourcing.wsstar.wsrfr.services.faults.ResourceUnknownFault;
import com.ebmwebsourcing.wsstar.wsrfrl.services.IImmediateResourceTermination;
import com.ebmwebsourcing.wsstar.wsrfrl.services.IScheduledResourceTermination;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.Duration;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;

public class WsnSubscription
implements IImmediateResourceTermination,
IScheduledResourceTermination {
    private static final String IMMEDIAT_TERMINAISON_REASON = "The \"Subscription\" resource have been detroy for some reason (Reloated Topic no longer supported, ...)";
    protected Logger logger;
    private SubscriptionManagerRP subscriptionResource = null;
    private EndpointReferenceType subscriptionReference = null;
    private ScheduledResourceTerminationRP terminationRP = null;
    protected String wsResourceEdpBase = "";
    protected QName wsResourceService = null;
    protected QName wsResourceInterface = null;
    protected List<TopicExpressionType> concreteTopExprs = null;
    protected ITransporterForWsnbPublisher transporter = null;

    public WsnSubscription(Logger logger, URI wsaAddress, String subscriptionId, Subscribe payload, ITransporterForWsnbPublisher transport) throws WsnbException, AbsWSStarFault {
        this.logger = logger;
        try {
            Object initTermTime;
            this.transporter = transport;
            this.subscriptionReference = (EndpointReferenceType)SOAUtil.getInstance().getXmlObjectFactory().create(EndpointReference.class);
            Address address = (Address)SOAUtil.getInstance().getXmlObjectFactory().create(Address.class);
            address.setValue(wsaAddress);
            this.subscriptionReference.setAddress(address);
            ReferenceParameters refParams = (ReferenceParameters)SOAUtil.getInstance().getXmlObjectFactory().create(ReferenceParameters.class);
            refParams.addAny((Object)Wsnb4ServUtils.createSubscriptionIdAsReferenceParamElt(subscriptionId));
            this.concreteTopExprs = new ArrayList<TopicExpressionType>();
            this.subscriptionReference.setReferenceParameters(refParams);
            this.subscriptionResource = RefinedWsnbFactory.getInstance().createSubscriptionManagerRP(payload.getConsumerReference());
            FilterType ft = payload.getFilter();
            if (ft != null) {
                this.subscriptionResource.setFilter(ft);
            }
            this.subscriptionResource.setCreationTime(new Date());
            SubscriptionPolicyType subsPolicy = payload.getSubscriptionPolicy();
            if (subsPolicy != null) {
                this.subscriptionResource.setSubscriptionPolicy(subsPolicy);
            }
            if ((initTermTime = payload.getInitialTerminationTime()) != null) {
                Date termTimeValue = null;
                if (initTermTime instanceof Duration) {
                    Duration duration = (Duration)initTermTime;
                    termTimeValue = new Date();
                    duration.addTo(termTimeValue);
                } else {
                    termTimeValue = (Date)initTermTime;
                }
                if (!termTimeValue.after(new Date())) {
                    try {
                        throw new UnacceptableInitialTerminationTimeFault(WsnbFaultMessageContentConstants.FAULT_DESCRIPTION_LANGUAGE, "The value of InitialTerminationTime specified in the Subscribe message was not\tacceptable to the NotificationProducer.");
                    }
                    catch (WsrfbfException e) {
                        new WsnbException((Throwable)e);
                    }
                }
                CurrentTime currentTime = RefinedWsrfrlFactory.getInstance().createCurrentTime(new Date());
                TerminationTime terminationTime = RefinedWsrfrlFactory.getInstance().createTerminationTime(termTimeValue);
                this.terminationRP = RefinedWsrfrlFactory.getInstance().createScheduledResourceTerminationRP(currentTime, terminationTime);
            }
        }
        catch (WsrfrlException e) {
            throw new WsnbException((Throwable)e);
        }
    }

    public WsnSubscription(Logger logger, URI wsaAddress, String subscriptionId, SubscriptionManagerRP subscriptionRP) throws WsnbException {
        this.concreteTopExprs = new ArrayList<TopicExpressionType>();
        this.subscriptionResource = subscriptionRP;
        this.subscriptionReference = (EndpointReferenceType)SOAUtil.getInstance().getXmlObjectFactory().create(EndpointReference.class);
        Address address = (Address)SOAUtil.getInstance().getXmlObjectFactory().create(Address.class);
        address.setValue(wsaAddress);
        this.subscriptionReference.setAddress(address);
        ReferenceParameters refParams = (ReferenceParameters)SOAUtil.getInstance().getXmlObjectFactory().create(ReferenceParameters.class);
        refParams.addAny((Object)Wsnb4ServUtils.createSubscriptionIdAsReferenceParamElt(subscriptionId));
        this.subscriptionReference.setReferenceParameters(refParams);
        this.logger = logger;
    }

    public String getWsResourceEdpBase() {
        return this.wsResourceEdpBase;
    }

    public void setWsResourceEdpBase(String subscriptionEdp) {
        this.wsResourceEdpBase = subscriptionEdp;
    }

    public QName getWsrfSubscriptionService() {
        return this.wsResourceService;
    }

    public void setWsrfSubscriptionService(QName subscriptionService) {
        this.wsResourceService = subscriptionService;
    }

    public QName getWsrfSubscriptionInterface() {
        return this.wsResourceInterface != null ? this.wsResourceInterface : WsnbConstants.SUBSCRIPTION_MANAGER_INTERFACE;
    }

    public void setWsrfSubscriptionInterface(QName subscriptionsMgrInterface) {
        this.wsResourceInterface = subscriptionsMgrInterface;
    }

    public EndpointReferenceType getSubscriptionReference() {
        return this.subscriptionReference;
    }

    public TerminationTime getTerminationTime() {
        if (this.terminationRP != null) {
            return this.terminationRP.getTerminationTime();
        }
        return null;
    }

    public SubscriptionManagerRP getSubscriptionResource() {
        return this.subscriptionResource;
    }

    public SetTerminationTimeResponse setTerminationTime(SetTerminationTime request) throws WsrfrlException, AbsWSStarFault {
        this.logger.log(Level.FINE, "performs a \"SetTerminationTime\" request ...");
        SetTerminationTimeResponse response = null;
        if (this.subscriptionResource == null) {
            try {
                throw new ResourceUnknownFault(WsnbFaultMessageContentConstants.FAULT_DESCRIPTION_LANGUAGE, "The SubscriptionManager is acting as a WS-Resource, and the resource identified in the message is not known to the Web service.");
            }
            catch (WsrfrException e1) {
                throw new WsrfrlException((Throwable)e1);
            }
            catch (WsrfbfException e1) {
                throw new WsrfrlException((Throwable)e1);
            }
        }
        Object newTerminationTimeVal = request.getRequestedTerminationTime() == null ? request.getRequestedLifetimeDuration() : request.getRequestedTerminationTime();
        Date currentTimeVar = new Date();
        Date newTerminationTime = null;
        if (newTerminationTimeVal instanceof Duration) {
            ((Duration)newTerminationTimeVal).addTo(currentTimeVar);
        } else {
            newTerminationTime = (Date)newTerminationTimeVal;
        }
        this.terminationRP.getTerminationTime().setValue(newTerminationTime);
        response = RefinedWsrfrlFactory.getInstance().createSetTerminationTimeResponse(currentTimeVar, newTerminationTime);
        return response;
    }

    public DestroyResponse destroy(Destroy payload) throws WsrfrlException, AbsWSStarFault {
        this.logger.log(Level.FINE, "performs a \"Destroy\" request ...");
        EndpointReferenceType consumerRef = this.subscriptionResource.getConsumerReference();
        this.subscriptionResource = null;
        this.subscriptionReference = null;
        this.terminationRP = null;
        if (this.transporter != null) {
            TerminationNotification terminationNotification = RefinedWsrfrlFactory.getInstance().createTerminationNotification(new Date());
            terminationNotification.setTerminationReason((Object)Wsnb4ServUtils.createSimpleReasonElement(IMMEDIAT_TERMINAISON_REASON));
            try {
                Document notifAsDoc = Wsnb4ServUtils.getWsrfrlWriter().writeTerminationNotificationAsDOM(terminationNotification);
                NotificationMessageHolderType.Message message = RefinedWsnbFactory.getInstance().createNotificationMessageHolderTypeMessage(notifAsDoc.getDocumentElement());
                NotificationMessageHolderType formattedNotif = RefinedWsnbFactory.getInstance().createNotificationMessageHolderType(message);
                TopicExpressionType topic = RefinedWsnbFactory.getInstance().createTopicExpressionType(WstopConstants.SIMPLE_TOPIC_EXPRESSION_DIALECT_URI);
                topic.addTopicNamespace("wsrf-rl", new URI("http://docs.oasis-open.org/wsrf/rl-2"));
                topic.setContent("wsrf-rl:ResourceTermination");
                formattedNotif.setTopic(topic);
                Notify notifPayload = RefinedWsnbFactory.getInstance().createNotify(formattedNotif);
                this.transporter.sendNotifyRequest(consumerRef, notifPayload);
            }
            catch (WsnbException e) {
                new WsnbException((Throwable)e);
            }
            catch (URISyntaxException e) {
                new WsnbException((Throwable)e);
            }
        }
        return RefinedWsrfrlFactory.getInstance().createDestroyResponse();
    }

    public EndpointReferenceType getConsumerEdpRef() throws WsnbException {
        return this.subscriptionResource.getConsumerReference();
    }

    public List<TopicExpressionType> getTopicExpressionOfSubscription() throws WsnbException {
        FilterType filter = this.subscriptionResource.getFilter();
        return filter != null ? filter.getTopicExpressions() : null;
    }

    public FilterType getFilterOfSubscription() throws WsnbException {
        return this.subscriptionResource.getFilter();
    }

    public SubscriptionPolicyType getPolicyOfSubscription() throws WsnbException {
        return this.subscriptionResource.getSubscriptionPolicy();
    }

    public List<TopicExpressionType> getAssociatedTopicExprs() {
        return this.concreteTopExprs;
    }

    public void setAssociatedTopicExprs(List<TopicExpressionType> concreteTopics) {
        this.concreteTopExprs.clear();
        this.concreteTopExprs.addAll(concreteTopics);
    }

    public int removeAssociatedTopicExpr(TopicExpressionType concreteTopic) {
        int remainingTopicExprs = this.concreteTopExprs.size();
        ArrayList<TopicExpressionType> topExprstoRemove = new ArrayList<TopicExpressionType>();
        String concreteTopicContent = concreteTopic.getContent();
        QName concreteTopicNamespace = (QName)concreteTopic.getTopicNamespaces().get(0);
        for (TopicExpressionType topicItem : this.concreteTopExprs) {
            if (!concreteTopicNamespace.equals(topicItem.getTopicNamespaces().get(0)) || !topicItem.getContent().startsWith(concreteTopicContent)) continue;
            topExprstoRemove.add(topicItem);
        }
        for (TopicExpressionType topicItem : topExprstoRemove) {
            this.concreteTopExprs.remove(topicItem);
        }
        remainingTopicExprs = this.concreteTopExprs.size();
        return remainingTopicExprs;
    }
}

