/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.notification.filter.messagecontent;

import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.QueryExpressionType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Subscribe;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WSNotificationExtensionException;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WsnSpecificTypeHelper;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.ow2.petals.component.framework.notification.filter.AbstractFilter;
import org.w3c.dom.Document;

public class XPathFilter
extends AbstractFilter {
    private XPath xPath = null;
    private List<XPathExpression> xpathExpressionList = null;

    public XPathFilter(Subscribe subscribe) throws XPathExpressionException, WSNotificationExtensionException, WSNotificationException {
        super(subscribe);
        String xPathString = null;
        XPathExpression xpathExpression = null;
        if (this.filterType != null) {
            List queryExpressionList = this.filterType.getMessageContentList();
            for (QueryExpressionType queryExpression : queryExpressionList) {
                if (!queryExpression.getDialect().equals("http://www.w3.org/TR/1999/REC-xpath-19991116")) continue;
                if (this.xPath == null) {
                    this.xPath = XPathFactory.newInstance().newXPath();
                }
                if (this.xpathExpressionList == null) {
                    this.xpathExpressionList = new CopyOnWriteArrayList<XPathExpression>();
                }
                if ((xPathString = WsnSpecificTypeHelper.getXpathExpression((QueryExpressionType)queryExpression)) == null || (xpathExpression = this.xPath.compile(xPathString)) == null) continue;
                this.xpathExpressionList.add(xpathExpression);
            }
        }
    }

    public boolean isNotifiable(Object content) {
        String result = null;
        Document document = null;
        try {
            if (this.xPath != null && this.xpathExpressionList != null) {
                for (XPathExpression xpathExpression : this.xpathExpressionList) {
                    if (content == null || !(content instanceof Document)) {
                        return false;
                    }
                    document = (Document)content;
                    result = xpathExpression.evaluate(document);
                    this.xPath.reset();
                    if (result != null && result.length() != 0 && !result.equals("false")) continue;
                    return false;
                }
            }
        }
        catch (XPathExpressionException e) {
            return false;
        }
        return true;
    }
}

