/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.util;

import java.util.Set;
import javax.activation.DataHandler;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.api.util.ExchangeUtil;
import org.ow2.petals.component.framework.message.ExchangeImpl;
import org.ow2.petals.component.framework.util.UtilFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public final class ExchangeUtilImpl
implements ExchangeUtil {
    public Exchange copyExchange(MessageExchangeFactory mef, Exchange source) throws MessagingException, PEtALSCDKException {
        MessageExchange msgEx = mef.createExchange(source.getPattern());
        ExchangeImpl target = new ExchangeImpl(msgEx);
        if (source.getEndpoint() != null) {
            target.setEndpoint(source.getEndpoint());
        }
        target.setInterfaceName(source.getInterfaceName());
        target.setService(source.getService());
        target.setOperation(source.getOperation());
        target.setStatus(source.getStatus());
        if (source.getError() != null) {
            target.setError(source.getError());
        }
        if (source.getFault() != null) {
            target.setFault(source.getFault());
        }
        if (source.getInMessage() != null && source.getInMessage().getContent() != null) {
            this.copyNormalizedMessage(source.getInMessage(), target.getInMessage());
        }
        if (source.getOutMessage() != null && source.getOutMessage().getContent() != null) {
            this.copyNormalizedMessage(source.getOutMessage(), target.getOutMessage());
        }
        this.copyExchangeProperties(source, target);
        return target;
    }

    public void copyNormalizedMessage(NormalizedMessage originalNm, NormalizedMessage copyNm) throws MessagingException, PEtALSCDKException {
        Document contentDoc = UtilFactory.getSourceUtil().createDocument(originalNm.getContent());
        DOMSource source = UtilFactory.getSourceUtil().createDOMSource(contentDoc);
        copyNm.setContent((Source)source);
        originalNm.setContent((Source)source);
        Set propertyNames = originalNm.getPropertyNames();
        for (String propertyName : propertyNames) {
            copyNm.setProperty(propertyName, originalNm.getProperty(propertyName));
        }
        Set inAttachmentNames = originalNm.getAttachmentNames();
        if (inAttachmentNames != null) {
            for (String attachmentName : inAttachmentNames) {
                DataHandler attDh = originalNm.getAttachment(attachmentName);
                copyNm.addAttachment(attachmentName, attDh);
            }
        }
        copyNm.setSecuritySubject(originalNm.getSecuritySubject());
    }

    public boolean isPetalsException(Fault fault) throws PEtALSCDKException {
        if (fault == null || fault.getContent() == null) {
            return false;
        }
        NodeList resList = UtilFactory.getSourceUtil().createDocument(fault.getContent()).getElementsByTagName("faultactor");
        if (resList != null && resList.getLength() > 0) {
            return "http://petals.ow2.org/exception".equals(resList.item(0).getTextContent());
        }
        return false;
    }

    public void copyExchangeProperties(Exchange source, Exchange target) throws MessagingException, PEtALSCDKException {
        if (source.getPropertyNames() != null) {
            for (Object property : source.getPropertyNames()) {
                String key;
                if (!(property instanceof String) || !(key = (String)property).startsWith("org.ow2.petals.propagate")) continue;
                target.setProperty(key, source.getProperty(key));
            }
        }
    }

    public boolean isBaseNotification(Exchange exchange) {
        if (exchange == null || exchange.getInterfaceName() == null || exchange.getInterfaceName().getNamespaceURI() == null) {
            return false;
        }
        return "http://docs.oasis-open.org/wsn/bw-2".equals(exchange.getInterfaceName().getNamespaceURI());
    }
}

