/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import javax.activation.DataHandler;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;

public class NormalizedMessageUtil {
    private static final String DATE_FORMAT = "ddMMyyHHmmssSSS";

    public static void copyAttachments(NormalizedMessage from, NormalizedMessage to) throws MessagingException {
        Set attachmentIds = from.getAttachmentNames();
        for (Object id : attachmentIds) {
            String attachName = (String)id;
            DataHandler dh = from.getAttachment(attachName);
            to.addAttachment(attachName, dh);
        }
    }

    public static void copyContent(NormalizedMessage from, NormalizedMessage to) throws MessagingException {
        to.setContent(from.getContent());
    }

    public static void copyProperties(NormalizedMessage from, NormalizedMessage to) {
        Set propertiesNames = from.getPropertyNames();
        for (Object propertyName : propertiesNames) {
            String name = (String)propertyName;
            Object value = from.getProperty(name);
            to.setProperty(name, value);
        }
    }

    public static void writeAttachmentsToFiles(NormalizedMessage nm, File destDir) {
        Set attachments = nm.getAttachmentNames();
        for (Object attachmentId : attachments) {
            NormalizedMessageUtil.writeAttachmentToFile(nm.getAttachment((String)attachmentId), destDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeAttachmentToFile(DataHandler handler, File destDir) {
        FileOutputStream fos = null;
        boolean destDirOk = true;
        try {
            if (!destDir.exists()) {
                destDirOk = destDir.mkdirs();
            }
            if (destDirOk) {
                File outFile = new File(destDir.getAbsolutePath(), handler.getName());
                String ext = "";
                if (outFile.exists()) {
                    SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
                    ext = sdf.format(new Date(System.currentTimeMillis()));
                }
                fos = new FileOutputStream(new File(outFile.getAbsoluteFile() + ext));
                handler.writeTo(fos);
                fos.flush();
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {}
        }
    }
}

