/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.util;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.ow2.petals.component.framework.api.util.XSLTUtil;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSLTUtilImpl
implements XSLTUtil {
    private DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
    private DocumentBuilder builder = null;
    private TransformerFactory transformerFactory = null;

    public XSLTUtilImpl() throws ParserConfigurationException {
        this.dFactory.setNamespaceAware(true);
        this.builder = this.dFactory.newDocumentBuilder();
        this.transformerFactory = TransformerFactory.newInstance();
    }

    public Document loadXML(String filename) throws IOException, ParserConfigurationException, SAXException {
        return this.builder.parse(new File(filename));
    }

    public Document transformDocument(Document xmlDocument, String xsltFilename) throws TransformerException, ParserConfigurationException {
        return this.transformDocument(xmlDocument, null, xsltFilename);
    }

    public Document transformDocument(Document xmlDocument, Source xsltSource) throws TransformerException, ParserConfigurationException {
        return this.transformDocument(xmlDocument, null, xsltSource);
    }

    public String transformDocumentAsString(Document xmlDocument, String xsltFilename) throws TransformerFactoryConfigurationError, TransformerException {
        return this.transformDocumentAsString(xmlDocument, null, xsltFilename);
    }

    public String transformDocumentAsString(Document xmlDocument, Source xsltSource) throws TransformerFactoryConfigurationError, TransformerException {
        return this.transformDocumentAsString(xmlDocument, null, xsltSource);
    }

    public Document transformDocument(Document xmlDocument, Hashtable<String, String> parameters, Source xsltSource) throws TransformerException, ParserConfigurationException {
        Transformer transformer = this.createTransformer(parameters, xsltSource);
        return this.transformDocument(xmlDocument, transformer);
    }

    public Document transformDocument(Document xmlDocument, Transformer transformer) throws TransformerException, ParserConfigurationException {
        Document dstDocument = null;
        if (transformer != null) {
            dstDocument = this.builder.newDocument();
            DOMResult domResult = new DOMResult(dstDocument);
            transformer.transform(this.xslNormalizeAsSource(xmlDocument), domResult);
            transformer.reset();
        }
        return dstDocument;
    }

    public Document transformDocument(Document xmlDocument, Hashtable<String, String> parameters, String xsltFilename) throws TransformerException, ParserConfigurationException {
        Transformer transformer = this.createTransformer(parameters, new StreamSource(xsltFilename));
        return this.transformDocument(xmlDocument, transformer);
    }

    public String transformDocumentAsString(Document xmlDocument, Hashtable<String, String> parameters, String xsltFilename) throws TransformerFactoryConfigurationError, TransformerException {
        return this.transformDocumentAsString(xmlDocument, parameters, new StreamSource(xsltFilename));
    }

    public String transformDocumentAsString(Document xmlDocument, Hashtable<String, String> parameters, Source xsltSource) throws TransformerFactoryConfigurationError, TransformerException {
        Transformer transformer = this.createTransformer(parameters, xsltSource);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        transformer.transform(this.xslNormalizeAsSource(xmlDocument), streamResult);
        transformer.reset();
        return stringWriter.toString();
    }

    public Transformer createTransformer(Hashtable<String, String> parameters, Source xsltSource) throws TransformerFactoryConfigurationError, TransformerException {
        Transformer transformer = null;
        Source source = this.xslNormalize(xsltSource);
        transformer = this.transformerFactory.newTransformer(source);
        if (parameters != null) {
            Enumeration<String> keys = parameters.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                String value = parameters.get(key);
                transformer.setParameter(key, value);
            }
        }
        return transformer;
    }

    public Transformer createTransformer(Source xsltSource) throws TransformerFactoryConfigurationError, TransformerException {
        return this.createTransformer(null, xsltSource);
    }

    private Document xslNormalize(Document document) throws TransformerException {
        Transformer transformer = this.transformerFactory.newTransformer();
        DOMResult dr = new DOMResult();
        DOMSource source = new DOMSource(document);
        transformer.transform(source, dr);
        transformer.reset();
        return (Document)dr.getNode();
    }

    private Source xslNormalize(Source source) throws TransformerException {
        Transformer transformer = this.transformerFactory.newTransformer();
        DOMResult dr = new DOMResult();
        transformer.transform(source, dr);
        transformer.reset();
        Document newDoc = (Document)dr.getNode();
        return new DOMSource(newDoc);
    }

    public Source xslNormalizeAsSource(Document document) throws TransformerException {
        Document newDoc = this.xslNormalize(document);
        return new DOMSource(newDoc);
    }
}

