/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type.basic;

import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.type.AegisType;
import org.apache.cxf.aegis.type.basic.BeanTypeInfo;
import org.apache.cxf.aegis.type.basic.BeanTypePropertyInfo;
import org.apache.cxf.aegis.util.NamespaceHelper;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.w3c.dom.Element;

public class XMLBeanTypeInfo
extends BeanTypeInfo {
    private static final Logger LOG = LogUtils.getL7dLogger(XMLBeanTypeInfo.class);
    private List mappings;
    private Map<QName, BeanTypePropertyInfo> name2PropertyInfo = new HashMap<QName, BeanTypePropertyInfo>();

    public XMLBeanTypeInfo(Class typeClass, List mappings, String defaultNS) {
        super(typeClass, defaultNS);
        this.mappings = mappings;
    }

    @Override
    protected boolean registerType(PropertyDescriptor desc) {
        Element e = this.getPropertyElement(desc.getName());
        if (e != null && DOMUtils.getAttributeValueEmptyNull(e, "type") != null) {
            return false;
        }
        return super.registerType(desc);
    }

    @Override
    protected void mapProperty(PropertyDescriptor pd) {
        block21: {
            boolean element;
            Element e = this.getPropertyElement(pd.getName());
            String style = null;
            QName mappedName = null;
            if (e != null) {
                String ignore = DOMUtils.getAttributeValueEmptyNull(e, "ignore");
                if (ignore != null && ignore.equals("true")) {
                    return;
                }
                LOG.finest("Found mapping for property " + pd.getName());
                style = DOMUtils.getAttributeValueEmptyNull(e, "style");
            }
            if (style == null) {
                style = "element";
            }
            boolean qualify = (element = "element".equals(style)) ? this.isQualifyElements() : this.isQualifyAttributes();
            String namespace = null;
            if (qualify) {
                namespace = this.getDefaultNamespace();
            }
            if (e != null) {
                mappedName = NamespaceHelper.createQName(e, DOMUtils.getAttributeValueEmptyNull(e, "mappedName"), namespace);
            }
            if (mappedName == null) {
                mappedName = this.createMappedName(pd, qualify);
            }
            if (e != null) {
                String maxOccurs;
                String minOccurs;
                String nillableVal;
                String explicitTypeName;
                QName mappedType = NamespaceHelper.createQName(e, DOMUtils.getAttributeValueEmptyNull(e, "typeName"), this.getDefaultNamespace());
                if (mappedType != null) {
                    this.mapTypeName(mappedName, mappedType);
                }
                if ((explicitTypeName = DOMUtils.getAttributeValueEmptyNull(e, "type")) != null) {
                    try {
                        Class<?> typeClass = ClassLoaderUtils.loadClass(explicitTypeName, XMLBeanTypeInfo.class);
                        AegisType customTypeObject = (AegisType)typeClass.newInstance();
                        this.mapType(mappedName, customTypeObject);
                        QName schemaType = mappedType;
                        if (schemaType == null) {
                            schemaType = this.getTypeMapping().getTypeQName(pd.getPropertyType());
                        }
                        customTypeObject.setTypeClass(typeClass);
                        customTypeObject.setSchemaType(schemaType);
                    }
                    catch (ClassNotFoundException e1) {
                    }
                    catch (InstantiationException e2) {
                    }
                    catch (IllegalAccessException e3) {
                        // empty catch block
                    }
                }
                if ((nillableVal = DOMUtils.getAttributeValueEmptyNull(e, "nillable")) != null && nillableVal.length() > 0) {
                    this.ensurePropertyInfo(mappedName).setNillable(Boolean.valueOf(nillableVal));
                }
                if ((minOccurs = DOMUtils.getAttributeValueEmptyNull(e, "minOccurs")) != null && minOccurs.length() > 0) {
                    this.ensurePropertyInfo(mappedName).setMinOccurs(Integer.parseInt(minOccurs));
                }
                if ((maxOccurs = DOMUtils.getAttributeValueEmptyNull(e, "maxOccurs")) != null && maxOccurs.length() > 0) {
                    this.ensurePropertyInfo(mappedName).setMinOccurs(Integer.parseInt(maxOccurs));
                }
            }
            try {
                if ("element".equals(style)) {
                    this.mapElement(pd.getName(), mappedName);
                    break block21;
                }
                if ("attribute".equals(style)) {
                    this.mapAttribute(pd.getName(), mappedName);
                    break block21;
                }
                throw new DatabindingException("Invalid style: " + style);
            }
            catch (DatabindingException ex) {
                ex.prepend("Couldn't create type for property " + pd.getName() + " on " + this.getTypeClass());
                throw ex;
            }
        }
    }

    private Element getPropertyElement(String name2) {
        for (Element mapping2 : this.mappings) {
            List<Element> elements = DOMUtils.getChildrenWithName(mapping2, "", "property");
            for (int i = 0; i < elements.size(); ++i) {
                Element e = elements.get(i);
                String name = DOMUtils.getAttributeValueEmptyNull(e, "name");
                if (name == null || !name.equals(name2)) continue;
                return e;
            }
        }
        return null;
    }

    @Override
    public boolean isNillable(QName name) {
        BeanTypePropertyInfo info = this.getPropertyInfo(name);
        if (info != null) {
            return info.isNillable();
        }
        return super.isNillable(name);
    }

    @Override
    public int getMinOccurs(QName name) {
        BeanTypePropertyInfo info = this.getPropertyInfo(name);
        if (info != null) {
            return info.getMinOccurs();
        }
        return super.getMinOccurs(name);
    }

    @Override
    public int getMaxOccurs(QName name) {
        BeanTypePropertyInfo info = this.getPropertyInfo(name);
        if (info != null) {
            return info.getMaxOccurs();
        }
        return super.getMaxOccurs(name);
    }

    private BeanTypePropertyInfo getPropertyInfo(QName name) {
        return this.name2PropertyInfo.get(name);
    }

    private BeanTypePropertyInfo ensurePropertyInfo(QName name) {
        BeanTypePropertyInfo result = this.getPropertyInfo(name);
        if (result == null) {
            result = new BeanTypePropertyInfo();
            this.name2PropertyInfo.put(name, result);
        }
        return result;
    }
}

