/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.tcp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.tcp.DataCodingUtils;
import org.apache.cxf.binding.soap.tcp.SoapTcpOutputStream;
import org.apache.cxf.binding.soap.tcp.SoapTcpUtils;
import org.apache.cxf.binding.soap.tcp.frames.SoapTcpFrame;
import org.apache.cxf.binding.soap.tcp.frames.SoapTcpFrameContentDescription;
import org.apache.cxf.binding.soap.tcp.frames.SoapTcpFrameHeader;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.Configurable;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.policy.Assertor;

public class TCPConduit
extends AbstractConduit
implements Configurable,
Assertor {
    private static final Logger LOG = LogUtils.getL7dLogger(TCPConduit.class);
    private Socket socket;
    private InputStream in;
    private OutputStream out;
    private String endPointAddress;

    public TCPConduit(EndpointReferenceType t) throws IOException {
        super(t);
        String hostName = null;
        int port = 0;
        String address = t.getAddress().getValue();
        if (address.contains("soap.tcp://")) {
            this.endPointAddress = address;
            int beginIndex = address.indexOf("://");
            int endIndex = address.indexOf(":", beginIndex + 1);
            hostName = address.substring(beginIndex + 3, endIndex);
            beginIndex = endIndex;
            endIndex = address.indexOf("/", beginIndex);
            port = Integer.parseInt(address.substring(beginIndex + 1, endIndex));
        }
        this.socket = new Socket(hostName, port);
        this.in = this.socket.getInputStream();
        this.out = this.socket.getOutputStream();
        this.out.write("vnd.sun.ws.tcp".getBytes("US-ASCII"));
        DataCodingUtils.writeInts4(this.out, 1, 0, 1, 0);
        this.out.flush();
        int[] version = new int[4];
        DataCodingUtils.readInts4(this.in, version, 4);
        this.initSession();
    }

    public TCPConduit(EndpointInfo ei) throws IOException {
        this(ei.getTarget());
    }

    private void initSession() throws IOException {
        String initSessionMessage = "<s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\"><s:Body><initiateSession xmlns=\"http://servicechannel.tcp.transport.ws.xml.sun.com/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"/></s:Body></s:Envelope>";
        byte[] initSessionMessageBytes = null;
        try {
            initSessionMessageBytes = "<s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\"><s:Body><initiateSession xmlns=\"http://servicechannel.tcp.transport.ws.xml.sun.com/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"/></s:Body></s:Envelope>".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        SoapTcpFrameContentDescription contentDesc = new SoapTcpFrameContentDescription();
        contentDesc.setContentId(0);
        Hashtable<Integer, String> parameters = new Hashtable<Integer, String>();
        parameters.put(0, "utf-8");
        contentDesc.setParameters(parameters);
        SoapTcpFrameHeader header = new SoapTcpFrameHeader(0, contentDesc);
        SoapTcpFrame frame = new SoapTcpFrame();
        frame.setHeader(header);
        frame.setChannelId(0);
        frame.setPayload(initSessionMessageBytes);
        try {
            SoapTcpUtils.writeMessageFrame(this.out, frame);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        SoapTcpFrame response = SoapTcpUtils.readMessageFrame(this.in);
        if (!SoapTcpUtils.checkSingleFrameResponse(response, "initiateSessionResponse")) {
            throw new IOException("Could not initiate SOAP/TCP connection.");
        }
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public String getBeanName() {
        return null;
    }

    @Override
    public void assertMessage(Message message) {
    }

    @Override
    public boolean canAssert(QName type) {
        return false;
    }

    @Override
    public void prepare(Message message) throws IOException {
        SoapTcpOutputStream soapTcpOutputStream = new SoapTcpOutputStream(this.in, this.out, message, this.endPointAddress, this.incomingObserver);
        message.setContent(OutputStream.class, soapTcpOutputStream);
    }

    @Override
    public void close(Message message) {
    }

    @Override
    public void close() {
        try {
            this.in.close();
            this.out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

