/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.search;

import java.text.SimpleDateFormat;
import java.util.Map;
import org.apache.cxf.jaxrs.ext.search.ConditionType;
import org.apache.cxf.jaxrs.ext.search.SearchCondition;
import org.apache.cxf.jaxrs.ext.search.sql.SQLPrinterVisitor;

public final class SearchUtils {
    public static final String DATE_FORMAT_PROPERTY = "search.date-format";
    public static final String TIMEZONE_SUPPORT_PROPERTY = "search.timezone.support";

    private SearchUtils() {
    }

    public static SimpleDateFormat getDateFormat(Map<String, String> properties, String defaultFormat) {
        String dfProperty = properties.get(DATE_FORMAT_PROPERTY);
        return new SimpleDateFormat(dfProperty == null ? defaultFormat : dfProperty);
    }

    public static boolean isTimeZoneSupported(Map<String, String> properties, Boolean defaultValue) {
        String tzProperty = properties.get(TIMEZONE_SUPPORT_PROPERTY);
        return tzProperty == null ? defaultValue : Boolean.valueOf(tzProperty);
    }

    public static <T> String toSQL(SearchCondition<T> sc, String table, String ... columns) {
        SQLPrinterVisitor visitor = new SQLPrinterVisitor(table, columns);
        sc.accept(visitor);
        return visitor.getResult();
    }

    public static void startSqlQuery(StringBuilder sb, String table, String ... columns) {
        sb.append("SELECT ");
        if (columns.length > 0) {
            for (int i = 0; i < columns.length; ++i) {
                sb.append(columns[i]);
                if (i + 1 >= columns.length) continue;
                sb.append(",");
            }
        } else {
            sb.append("*");
        }
        sb.append(" FROM ").append(table).append(" WHERE ");
    }

    public static String conditionTypeToSqlOperator(ConditionType ct, String value) {
        String op;
        switch (ct) {
            case EQUALS: {
                op = value.contains("%") ? "LIKE" : "=";
                break;
            }
            case NOT_EQUALS: {
                op = value.contains("%") ? "NOT LIKE" : "<>";
                break;
            }
            case GREATER_THAN: {
                op = ">";
                break;
            }
            case GREATER_OR_EQUALS: {
                op = ">=";
                break;
            }
            case LESS_THAN: {
                op = "<";
                break;
            }
            case LESS_OR_EQUALS: {
                op = "<=";
                break;
            }
            default: {
                String msg = String.format("Condition type %s is not supported", ct.name());
                throw new RuntimeException(msg);
            }
        }
        return op;
    }
}

