/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.MultivaluedMap;

public class MetadataMap<K, V>
implements MultivaluedMap<K, V> {
    private boolean caseInsensitive;
    private Map<K, List<V>> m;

    public MetadataMap() {
        this.m = new LinkedHashMap<K, List<V>>();
    }

    public MetadataMap(int size) {
        this.m = new LinkedHashMap<K, List<V>>(size);
    }

    public MetadataMap(Map<K, List<V>> store) {
        this(store, false, false);
    }

    public MetadataMap(boolean readOnly, boolean caseInsensitive) {
        this(null, readOnly, caseInsensitive);
    }

    public MetadataMap(Map<K, List<V>> store, boolean readOnly, boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
        this.m = new LinkedHashMap<K, List<V>>();
        if (store != null) {
            for (Map.Entry<K, List<V>> entry : store.entrySet()) {
                ArrayList values = new ArrayList(entry.getValue());
                this.m.put(entry.getKey(), readOnly ? Collections.unmodifiableList(values) : values);
            }
        }
        if (readOnly) {
            this.m = Collections.unmodifiableMap(this.m);
        }
    }

    public void add(K key, V value) {
        ArrayList<V> data = this.get(key);
        if (data == null) {
            data = new ArrayList<V>();
            this.m.put(key, data);
        }
        data.add(value);
    }

    public V getFirst(K key) {
        Object data = this.get(key);
        return data == null ? null : (V)data.get(0);
    }

    public void putSingle(K key, V value) {
        ArrayList<V> data = new ArrayList<V>();
        data.add(value);
        this.put(key, data);
    }

    public void clear() {
        this.m.clear();
    }

    public boolean containsKey(Object key) {
        if (!this.caseInsensitive) {
            return this.m.containsKey(key);
        }
        for (K theKey : this.m.keySet()) {
            if (!theKey.toString().toLowerCase().equals(key.toString().toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public boolean containsValue(Object value) {
        return this.m.containsValue(value);
    }

    public Set<Map.Entry<K, List<V>>> entrySet() {
        return this.m.entrySet();
    }

    public List<V> get(Object key) {
        if (!this.caseInsensitive) {
            return this.m.get(key);
        }
        for (Map.Entry<K, List<V>> entry : this.m.entrySet()) {
            if (!entry.getKey().toString().toLowerCase().equals(key.toString().toLowerCase())) continue;
            return entry.getValue();
        }
        return null;
    }

    public boolean isEmpty() {
        return this.m.isEmpty();
    }

    public Set<K> keySet() {
        return this.m.keySet();
    }

    public List<V> put(K key, List<V> value) {
        return this.m.put(key, value);
    }

    public void putAll(Map<? extends K, ? extends List<V>> map) {
        this.m.putAll(map);
    }

    public List<V> remove(Object key) {
        return this.m.remove(key);
    }

    public int size() {
        return this.m.size();
    }

    public Collection<List<V>> values() {
        return this.m.values();
    }

    public int hashCode() {
        return ((Object)this.m).hashCode();
    }

    public boolean equals(Object o) {
        return ((Object)this.m).equals(o);
    }

    public String toString() {
        return this.m.toString();
    }
}

