/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms.continuations;

import java.util.Collection;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.continuations.Continuation;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.transport.jms.JMSConfiguration;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.listener.DefaultMessageListenerContainer;

public class JMSContinuation
implements Continuation {
    private Bus bus;
    private Message inMessage;
    private MessageObserver incomingObserver;
    private Collection<JMSContinuation> continuations;
    private AbstractMessageListenerContainer jmsListener;
    private JMSConfiguration jmsConfig;
    private volatile Object userObject;
    private volatile boolean isNew = true;
    private volatile boolean isPending;
    private volatile boolean isResumed;
    private Timer timer;

    public JMSContinuation(Bus b, Message m, MessageObserver observer, Collection<JMSContinuation> cList, AbstractMessageListenerContainer jmsListener, JMSConfiguration jmsConfig) {
        this.bus = b;
        this.inMessage = m;
        this.incomingObserver = observer;
        this.continuations = cList;
        this.jmsListener = jmsListener;
        this.jmsConfig = jmsConfig;
    }

    @Override
    public Object getObject() {
        return this.userObject;
    }

    @Override
    public boolean isNew() {
        return this.isNew;
    }

    @Override
    public boolean isPending() {
        return this.isPending;
    }

    @Override
    public boolean isResumed() {
        return this.isResumed;
    }

    @Override
    public synchronized void reset() {
        this.cancelTimerTask();
        this.isNew = true;
        this.isPending = false;
        this.isResumed = false;
        this.userObject = null;
    }

    @Override
    public synchronized void resume() {
        if (this.isResumed || !this.isPending) {
            return;
        }
        this.isResumed = true;
        this.cancelTimerTask();
        this.doResume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doResume() {
        this.updateContinuations(true);
        ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
        try {
            BusFactory.setThreadDefaultBus(this.bus);
            ClassLoader loader = this.bus.getExtension(ClassLoader.class);
            if (loader != null) {
                Thread.currentThread().setContextClassLoader(loader);
            }
            this.incomingObserver.onMessage(this.inMessage);
        }
        finally {
            this.isPending = false;
            BusFactory.setThreadDefaultBus(null);
            Thread.currentThread().setContextClassLoader(origLoader);
        }
    }

    @Override
    public void setObject(Object o) {
        this.userObject = o;
    }

    @Override
    public synchronized boolean suspend(long timeout) {
        if (this.isPending) {
            return false;
        }
        this.inMessage.getExchange().getInMessage().getInterceptorChain().suspend();
        this.updateContinuations(false);
        this.isNew = false;
        this.isResumed = false;
        this.isPending = true;
        if (timeout > 0L) {
            this.createTimerTask(timeout);
        }
        return true;
    }

    protected void createTimerTask(long timeout) {
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JMSContinuation jMSContinuation = JMSContinuation.this;
                synchronized (jMSContinuation) {
                    if (JMSContinuation.this.isPending) {
                        JMSContinuation.this.cancelTimerTask();
                        JMSContinuation.this.doResume();
                    }
                }
            }
        }, timeout);
    }

    protected void cancelTimerTask() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateContinuations(boolean remove) {
        if (this.jmsConfig.getMaxSuspendedContinuations() < 0 || this.jmsListener instanceof DefaultMessageListenerContainer && ((DefaultMessageListenerContainer)this.jmsListener).getCacheLevel() >= 3) {
            this.modifyList(remove);
            return;
        }
        Collection<JMSContinuation> collection = this.continuations;
        synchronized (collection) {
            this.modifyList(remove);
            if (this.continuations.size() >= this.jmsConfig.getMaxSuspendedContinuations()) {
                this.jmsListener.stop();
            } else if (!this.jmsListener.isRunning()) {
                int limit = this.jmsConfig.getReconnectPercentOfMax();
                if (limit < 0 || limit > 100) {
                    limit = 70;
                }
                limit = limit * this.jmsConfig.getMaxSuspendedContinuations() / 100;
                if (this.continuations.size() <= limit) {
                    this.jmsListener.start();
                }
            }
        }
    }

    protected void modifyList(boolean remove) {
        if (remove) {
            this.continuations.remove(this);
        } else {
            this.continuations.add(this);
        }
    }
}

