/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.servlet.servicelist;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.transport.AbstractDestination;
import org.apache.cxf.transport.servlet.servicelist.ServiceListWriter;

public class FormattedServiceListWriter
implements ServiceListWriter {
    private String styleSheetPath;
    private String title;
    private Map<String, String> atomMap;

    public FormattedServiceListWriter(String styleSheetPath, String title, Map<String, String> atomMap) {
        this.styleSheetPath = styleSheetPath;
        this.title = title;
        this.atomMap = atomMap;
    }

    @Override
    public String getContentType() {
        return "text/html; charset=UTF-8";
    }

    @Override
    public void writeServiceList(PrintWriter writer, AbstractDestination[] soapDestinations, AbstractDestination[] restDestinations) throws IOException {
        writer.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">");
        writer.write("<HTML><HEAD>");
        writer.write("<LINK type=\"text/css\" rel=\"stylesheet\" href=\"" + this.styleSheetPath + "\">");
        writer.write("<meta http-equiv=content-type content=\"text/html; charset=UTF-8\">");
        if (this.title != null) {
            writer.write("<title>" + this.title + "</title>");
        } else {
            writer.write("<title>CXF - Service list</title>");
        }
        writer.write("</head><body>");
        if (soapDestinations.length > 0 || restDestinations.length > 0) {
            this.writeSOAPEndpoints(writer, soapDestinations);
            this.writeRESTfulEndpoints(writer, restDestinations);
        } else {
            writer.write("<span class=\"heading\">No services have been found.</span>");
        }
        writer.write("</body></html>");
    }

    private void writeSOAPEndpoints(PrintWriter writer, AbstractDestination[] destinations) throws IOException {
        writer.write("<span class=\"heading\">Available SOAP services:</span><br/>");
        writer.write("<table>");
        for (AbstractDestination sd : destinations) {
            this.writerSoapEndpoint(writer, sd);
        }
        writer.write("</table><br/><br/>");
    }

    private void writerSoapEndpoint(PrintWriter writer, AbstractDestination sd) {
        writer.write("<tr><td>");
        writer.write("<span class=\"porttypename\">" + sd.getEndpointInfo().getInterface().getName().getLocalPart() + "</span>");
        writer.write("<ul>");
        for (OperationInfo oi : sd.getEndpointInfo().getInterface().getOperations()) {
            if (oi.getProperty("operation.is.synthetic") == Boolean.TRUE) continue;
            writer.write("<li>" + oi.getName().getLocalPart() + "</li>");
        }
        writer.write("</ul>");
        writer.write("</td><td>");
        String address = sd.getEndpointInfo().getAddress();
        writer.write("<span class=\"field\">Endpoint address:</span> <span class=\"value\">" + address + "</span>");
        writer.write("<br/><span class=\"field\">WSDL :</span> <a href=\"" + address + "?wsdl\">" + sd.getEndpointInfo().getService().getName() + "</a>");
        writer.write("<br/><span class=\"field\">Target namespace:</span> <span class=\"value\">" + sd.getEndpointInfo().getService().getTargetNamespace() + "</span>");
        FormattedServiceListWriter.addAtomLinkIfNeeded(address, this.atomMap, writer);
        writer.write("</td></tr>");
    }

    private void writeRESTfulEndpoints(PrintWriter writer, AbstractDestination[] restfulDests) throws IOException {
        writer.write("<span class=\"heading\">Available RESTful services:</span><br/>");
        writer.write("<table>");
        for (AbstractDestination sd : restfulDests) {
            this.writeRESTfulEndpoint(writer, sd);
        }
        writer.write("</table>");
    }

    private void writeRESTfulEndpoint(PrintWriter writer, AbstractDestination sd) {
        writer.write("<tr><td>");
        String address = sd.getEndpointInfo().getAddress();
        writer.write("<span class=\"field\">Endpoint address:</span> <span class=\"value\">" + address + "</span>");
        writer.write("<br/><span class=\"field\">WADL :</span> <a href=\"" + address + "?_wadl&_type=xml\">" + address + "?_wadl&type=xml" + "</a>");
        FormattedServiceListWriter.addAtomLinkIfNeeded(address, this.atomMap, writer);
        writer.write("</td></tr>");
    }

    private static void addAtomLinkIfNeeded(String address, Map<String, String> extMap, PrintWriter pw) {
        String atomAddress = FormattedServiceListWriter.getExtensionEndpointAddress(address, extMap);
        if (atomAddress != null) {
            pw.write("<br/><span class=\"field\">Atom Log Feed :</span> <a href=\"" + atomAddress + "\">" + atomAddress + "</a>");
        }
    }

    private static String getExtensionEndpointAddress(String endpointAddress, Map<String, String> extMap) {
        if (extMap != null) {
            for (Map.Entry<String, String> entry : extMap.entrySet()) {
                if (!endpointAddress.endsWith(entry.getKey())) continue;
                endpointAddress = endpointAddress.substring(0, endpointAddress.length() - entry.getKey().length());
                endpointAddress = endpointAddress + entry.getValue();
                return endpointAddress;
            }
        }
        return null;
    }
}

