/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.Duration;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxb.DatatypeFactory;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.ws.addressing.AddressingPropertiesImpl;
import org.apache.cxf.ws.addressing.VersionTransformer;
import org.apache.cxf.ws.addressing.v200408.AttributedURI;
import org.apache.cxf.ws.rm.AcceptType;
import org.apache.cxf.ws.rm.BindingFaultFactory;
import org.apache.cxf.ws.rm.CreateSequenceResponseType;
import org.apache.cxf.ws.rm.CreateSequenceType;
import org.apache.cxf.ws.rm.Destination;
import org.apache.cxf.ws.rm.DestinationSequence;
import org.apache.cxf.ws.rm.Expires;
import org.apache.cxf.ws.rm.Identifier;
import org.apache.cxf.ws.rm.OfferType;
import org.apache.cxf.ws.rm.RMConstants;
import org.apache.cxf.ws.rm.RMContextUtils;
import org.apache.cxf.ws.rm.RMEndpoint;
import org.apache.cxf.ws.rm.RMException;
import org.apache.cxf.ws.rm.RMManager;
import org.apache.cxf.ws.rm.RMUtils;
import org.apache.cxf.ws.rm.SequenceFault;
import org.apache.cxf.ws.rm.Source;
import org.apache.cxf.ws.rm.SourceSequence;
import org.apache.cxf.ws.rm.TerminateSequenceType;
import org.apache.cxf.ws.rm.manager.DestinationPolicyType;

public class Servant
implements Invoker {
    private static final Logger LOG = LogUtils.getL7dLogger(Servant.class);
    private RMEndpoint reliableEndpoint;
    private Identifier unattachedIdentifier;

    Servant(RMEndpoint rme) {
        this.reliableEndpoint = rme;
    }

    private void throwSequenceFault(SequenceFault sf, Exchange exchange) {
        Endpoint e = exchange.get(Endpoint.class);
        Binding b = null;
        if (null != e) {
            b = e.getBinding();
        }
        Bus bus = exchange.get(Bus.class);
        if (null != b && bus != null) {
            RMManager m = bus.getExtension(RMManager.class);
            LOG.fine("Manager: " + m);
            BindingFaultFactory bff = m.getBindingFaultFactory(b);
            Fault f = bff.createFault(sf);
            LogUtils.log(LOG, Level.SEVERE, "SEQ_FAULT_MSG", bff.toString(f));
            throw f;
        }
        throw new Fault(sf);
    }

    @Override
    public Object invoke(Exchange exchange, Object o) {
        block13: {
            LOG.fine("Invoking on RM Endpoint");
            OperationInfo oi = exchange.get(OperationInfo.class);
            if (null == oi) {
                LOG.fine("No operation info.");
                return null;
            }
            if (RMConstants.getCreateSequenceOperationName().equals(oi.getName()) || RMConstants.getCreateSequenceOnewayOperationName().equals(oi.getName())) {
                try {
                    return Collections.singletonList(this.createSequence(exchange.getInMessage()));
                }
                catch (SequenceFault ex) {
                    this.throwSequenceFault(ex, exchange);
                    break block13;
                }
                catch (Exception ex) {
                    throw new Fault(ex);
                }
            }
            if (RMConstants.getCreateSequenceResponseOnewayOperationName().equals(oi.getName())) {
                CreateSequenceResponseType createResponse = (CreateSequenceResponseType)this.getParameter(exchange.getInMessage());
                try {
                    this.createSequenceResponse(createResponse);
                }
                catch (SequenceFault ex) {
                    this.throwSequenceFault(ex, exchange);
                }
            } else if (RMConstants.getTerminateSequenceOperationName().equals(oi.getName())) {
                try {
                    this.terminateSequence(exchange.getInMessage());
                }
                catch (SequenceFault ex) {
                    this.throwSequenceFault(ex, exchange);
                }
                catch (RMException ex) {
                    throw new Fault(ex);
                }
            }
        }
        return null;
    }

    CreateSequenceResponseType createSequence(Message message) throws SequenceFault {
        OfferType offer;
        Expires ex;
        LOG.fine("Creating sequence");
        AddressingPropertiesImpl maps = RMContextUtils.retrieveMAPs(message, false, false);
        Message outMessage = message.getExchange().getOutMessage();
        if (null != outMessage) {
            RMContextUtils.storeMAPs(maps, outMessage, false, false);
        }
        CreateSequenceType create = (CreateSequenceType)this.getParameter(message);
        Destination destination = this.reliableEndpoint.getDestination();
        CreateSequenceResponseType createResponse = RMUtils.getWSRMFactory().createCreateSequenceResponseType();
        createResponse.setIdentifier(destination.generateSequenceIdentifier());
        DestinationPolicyType dp = this.reliableEndpoint.getManager().getDestinationPolicy();
        Duration supportedDuration = dp.getSequenceExpiration();
        if (null == supportedDuration) {
            supportedDuration = DatatypeFactory.PT0S;
        }
        if (null != (ex = create.getExpires()) || supportedDuration.isShorterThan(DatatypeFactory.PT0S)) {
            Duration effectiveDuration = supportedDuration;
            if (null != ex && supportedDuration.isLongerThan(ex.getValue())) {
                effectiveDuration = supportedDuration;
            }
            ex = RMUtils.getWSRMFactory().createExpires();
            ex.setValue(effectiveDuration);
            createResponse.setExpires(ex);
        }
        if (null != (offer = create.getOffer())) {
            AcceptType accept = RMUtils.getWSRMFactory().createAcceptType();
            if (dp.isAcceptOffers()) {
                Source source = this.reliableEndpoint.getSource();
                LOG.fine("Accepting inbound sequence offer");
                AttributedURI to = VersionTransformer.convert(maps.getTo());
                accept.setAcksTo(RMUtils.createReference2004(to.getValue()));
                SourceSequence seq = new SourceSequence(offer.getIdentifier(), null, createResponse.getIdentifier());
                seq.setExpires(offer.getExpires());
                seq.setTarget(VersionTransformer.convert(create.getAcksTo()));
                source.addSequence(seq);
                source.setCurrent(createResponse.getIdentifier(), seq);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Making offered sequence the current sequence for responses to " + createResponse.getIdentifier().getValue());
                }
            } else {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Refusing inbound sequence offer");
                }
                accept.setAcksTo(RMUtils.createNoneReference2004());
            }
            createResponse.setAccept(accept);
        }
        DestinationSequence seq = new DestinationSequence(createResponse.getIdentifier(), create.getAcksTo(), destination);
        seq.setCorrelationID(maps.getMessageID().getValue());
        destination.addSequence(seq);
        LOG.fine("returning " + createResponse);
        return createResponse;
    }

    public void createSequenceResponse(CreateSequenceResponseType createResponse) throws SequenceFault {
        LOG.fine("Creating sequence response");
        SourceSequence seq = new SourceSequence(createResponse.getIdentifier());
        seq.setExpires(createResponse.getExpires());
        Source source = this.reliableEndpoint.getSource();
        source.addSequence(seq);
        source.setCurrent(this.clearUnattachedIdentifier(), seq);
        Identifier offeredId = this.reliableEndpoint.getProxy().getOfferedIdentifier();
        if (null != offeredId) {
            AcceptType accept = createResponse.getAccept();
            assert (null != accept);
            Destination dest = this.reliableEndpoint.getDestination();
            String address = accept.getAcksTo().getAddress().getValue();
            if (!RMUtils.getAddressingConstants().getNoneURI().equals(address)) {
                DestinationSequence ds = new DestinationSequence(offeredId, accept.getAcksTo(), dest);
                dest.addSequence(ds);
            }
        }
    }

    public void terminateSequence(Message message) throws SequenceFault, RMException {
        LOG.fine("Terminating sequence");
        TerminateSequenceType terminate = (TerminateSequenceType)this.getParameter(message);
        Destination destination = this.reliableEndpoint.getDestination();
        Identifier sid = terminate.getIdentifier();
        DestinationSequence terminatedSeq = destination.getSequence(sid);
        if (null == terminatedSeq) {
            LOG.severe("No such sequence.");
            return;
        }
        destination.removeSequence(terminatedSeq);
        Source source = this.reliableEndpoint.getSource();
        for (SourceSequence outboundSeq : source.getAllSequences()) {
            if (!outboundSeq.offeredBy(sid) || outboundSeq.isLastMessage()) continue;
            if (!BigInteger.ZERO.equals(outboundSeq.getCurrentMessageNr())) break;
            source.removeSequence(outboundSeq);
            break;
        }
    }

    Object getParameter(Message message) {
        List resList = null;
        if (message != null) {
            resList = message.getContent(List.class);
        }
        if (resList != null) {
            return resList.get(0);
        }
        return null;
    }

    Identifier clearUnattachedIdentifier() {
        Identifier ret = this.unattachedIdentifier;
        this.unattachedIdentifier = null;
        return ret;
    }

    void setUnattachedIdentifier(Identifier i) {
        this.unattachedIdentifier = i;
    }
}

