/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.interceptors;

import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import org.apache.cxf.binding.soap.Soap11;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.message.Message;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.apache.cxf.ws.addressing.policy.MetadataConstants;
import org.apache.cxf.ws.policy.AbstractPolicyInterceptorProvider;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.policy.builder.primitive.PrimitiveAssertion;
import org.apache.cxf.ws.security.SecurityConstants;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.interceptors.SecureConversationInInterceptor;
import org.apache.cxf.ws.security.policy.interceptors.SecureConversationOutInterceptor;
import org.apache.cxf.ws.security.policy.model.AlgorithmSuite;
import org.apache.cxf.ws.security.policy.model.Binding;
import org.apache.cxf.ws.security.policy.model.SecureConversationToken;
import org.apache.cxf.ws.security.policy.model.SupportingToken;
import org.apache.cxf.ws.security.policy.model.Trust10;
import org.apache.cxf.ws.security.policy.model.Trust13;
import org.apache.cxf.ws.security.tokenstore.MemoryTokenStore;
import org.apache.cxf.ws.security.tokenstore.TokenStore;
import org.apache.cxf.ws.security.trust.STSClient;
import org.apache.neethi.All;
import org.apache.neethi.Assertion;
import org.apache.neethi.ExactlyOne;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.conversation.ConversationConstants;
import org.apache.ws.security.conversation.ConversationException;
import org.apache.ws.security.conversation.dkalgo.P_SHA1;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.util.Base64;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Element;

public class SecureConversationTokenInterceptorProvider
extends AbstractPolicyInterceptorProvider {
    static final Logger LOG = LogUtils.getL7dLogger(SecureConversationTokenInterceptorProvider.class);

    public SecureConversationTokenInterceptorProvider() {
        super(Arrays.asList(SP11Constants.SECURE_CONVERSATION_TOKEN, SP12Constants.SECURE_CONVERSATION_TOKEN));
        this.getOutInterceptors().add(new SecureConversationOutInterceptor());
        this.getOutFaultInterceptors().add(new SecureConversationOutInterceptor());
        this.getInInterceptors().add(new SecureConversationInInterceptor());
        this.getInFaultInterceptors().add(new SecureConversationInInterceptor());
    }

    static final Trust10 getTrust10(AssertionInfoMap aim) {
        Collection ais = (Collection)aim.get("Trust10");
        if (ais == null || ais.isEmpty()) {
            ais = (Collection)aim.get(SP11Constants.TRUST_10);
        }
        if (ais == null || ais.isEmpty()) {
            return null;
        }
        return (Trust10)((AssertionInfo)ais.iterator().next()).getAssertion();
    }

    static final Trust13 getTrust13(AssertionInfoMap aim) {
        Collection ais = (Collection)aim.get(SP12Constants.TRUST_13);
        if (ais == null || ais.isEmpty()) {
            return null;
        }
        return (Trust13)((AssertionInfo)ais.iterator().next()).getAssertion();
    }

    static final TokenStore getTokenStore(Message message) {
        TokenStore tokenStore = (TokenStore)message.getContextualProperty(TokenStore.class.getName());
        if (tokenStore == null) {
            tokenStore = new MemoryTokenStore();
            message.getExchange().get(Endpoint.class).getEndpointInfo().setProperty(TokenStore.class.getName(), tokenStore);
            message.getExchange().put(TokenStore.class.getName(), tokenStore);
        }
        return tokenStore;
    }

    static Assertion getAddressingPolicy(AssertionInfoMap aim, boolean optional) {
        Collection lst = (Collection)aim.get(MetadataConstants.USING_ADDRESSING_2004_QNAME);
        Assertion assertion = null;
        if (null != lst && !lst.isEmpty()) {
            assertion = ((AssertionInfo)lst.iterator().next()).getAssertion();
        }
        if (assertion == null && null != (lst = (Collection)aim.get(MetadataConstants.USING_ADDRESSING_2005_QNAME)) && !lst.isEmpty()) {
            assertion = ((AssertionInfo)lst.iterator().next()).getAssertion();
        }
        if (assertion == null && null != (lst = (Collection)aim.get(MetadataConstants.USING_ADDRESSING_2006_QNAME)) && !lst.isEmpty()) {
            assertion = ((AssertionInfo)lst.iterator().next()).getAssertion();
        }
        if (assertion == null) {
            return new PrimitiveAssertion(MetadataConstants.USING_ADDRESSING_2006_QNAME, optional);
        }
        if (optional) {
            return new PrimitiveAssertion(assertion.getName(), optional);
        }
        return assertion;
    }

    static String setupClient(STSClient client, SoapMessage message, AssertionInfoMap aim, SecureConversationToken itok, boolean endorse) {
        client.setTrust(SecureConversationTokenInterceptorProvider.getTrust10(aim));
        client.setTrust(SecureConversationTokenInterceptorProvider.getTrust13(aim));
        Policy pol = itok.getBootstrapPolicy();
        Policy p = new Policy();
        ExactlyOne ea = new ExactlyOne();
        p.addPolicyComponent((PolicyComponent)ea);
        All all = new All();
        all.addPolicyComponent((PolicyComponent)SecureConversationTokenInterceptorProvider.getAddressingPolicy(aim, false));
        ea.addPolicyComponent((PolicyComponent)all);
        if (endorse) {
            SupportingToken st = new SupportingToken(SPConstants.SupportTokenType.SUPPORTING_TOKEN_ENDORSING, SP12Constants.INSTANCE, message.getExchange().getBus().getExtension(PolicyBuilder.class));
            st.addToken(itok);
            all.addPolicyComponent((PolicyComponent)st);
        }
        pol = p.merge(pol);
        client.setPolicy(pol);
        client.setSoap11(message.getVersion() == Soap11.getInstance());
        client.setSecureConv(true);
        String s = message.getContextualProperty(Message.ENDPOINT_ADDRESS).toString();
        client.setLocation(s);
        AlgorithmSuite suite = SecureConversationTokenInterceptorProvider.getAlgorithmSuite(aim);
        if (suite != null) {
            client.setAlgorithmSuite(suite);
            int x = suite.getMaximumSymmetricKeyLength();
            if (x < 256) {
                client.setKeySize(x);
            }
        }
        Map<String, Object> ctx = client.getRequestContext();
        SecureConversationTokenInterceptorProvider.mapSecurityProps(message, ctx);
        return s;
    }

    private static AlgorithmSuite getAlgorithmSuite(AssertionInfoMap aim) {
        Binding transport = null;
        Collection ais = (Collection)aim.get(SP12Constants.TRANSPORT_BINDING);
        if (ais != null) {
            for (AssertionInfo ai : ais) {
                transport = (Binding)ai.getAssertion();
            }
        } else {
            ais = (Collection)aim.get(SP12Constants.ASYMMETRIC_BINDING);
            if (ais != null) {
                for (AssertionInfo ai : ais) {
                    transport = (Binding)ai.getAssertion();
                }
            } else {
                ais = (Collection)aim.get(SP12Constants.SYMMETRIC_BINDING);
                if (ais != null) {
                    for (AssertionInfo ai : ais) {
                        transport = (Binding)ai.getAssertion();
                    }
                }
            }
        }
        if (transport != null) {
            return transport.getAlgorithmSuite();
        }
        return null;
    }

    private static void mapSecurityProps(Message message, Map<String, Object> ctx) {
        for (String s : SecurityConstants.ALL_PROPERTIES) {
            Object v = message.getContextualProperty(s + ".sct");
            if (v == null) continue;
            ctx.put(s, v);
        }
    }

    static byte[] writeProofToken(String prefix, String namespace, W3CDOMStreamWriter writer, byte[] clientEntropy, int keySize) throws NoSuchAlgorithmException, WSSecurityException, ConversationException, XMLStreamException {
        byte[] secret = null;
        writer.writeStartElement(prefix, "RequestedProofToken", namespace);
        if (clientEntropy == null) {
            secret = WSSecurityUtil.generateNonce((int)(keySize / 8));
            writer.writeStartElement(prefix, "BinarySecret", namespace);
            writer.writeAttribute("Type", namespace + "/Nonce");
            writer.writeCharacters(Base64.encode((byte[])secret));
            writer.writeEndElement();
        } else {
            byte[] entropy = WSSecurityUtil.generateNonce((int)(keySize / 8));
            P_SHA1 psha1 = new P_SHA1();
            secret = psha1.createKey(clientEntropy, entropy, 0, (long)(keySize / 8));
            writer.writeStartElement(prefix, "ComputedKey", namespace);
            writer.writeCharacters(namespace + "/CK/PSHA1");
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeStartElement(prefix, "Entropy", namespace);
            writer.writeStartElement(prefix, "BinarySecret", namespace);
            writer.writeAttribute("Type", namespace + "/Nonce");
            writer.writeCharacters(Base64.encode((byte[])entropy));
            writer.writeEndElement();
        }
        writer.writeEndElement();
        return secret;
    }

    static Element writeSecurityTokenReference(W3CDOMStreamWriter writer, String id, String refValueType) {
        Reference ref = new Reference(writer.getDocument());
        ref.setURI(id);
        if (refValueType != null) {
            ref.setValueType(refValueType);
        }
        SecurityTokenReference str = new SecurityTokenReference(writer.getDocument());
        str.setReference(ref);
        writer.getCurrentNode().appendChild(str.getElement());
        return str.getElement();
    }

    static int getWSCVersion(String tokenTypeValue) throws ConversationException {
        if (tokenTypeValue == null) {
            return 1;
        }
        if (tokenTypeValue.startsWith("http://schemas.xmlsoap.org/ws/2005/02/sc")) {
            return ConversationConstants.getWSTVersion((String)"http://schemas.xmlsoap.org/ws/2005/02/sc");
        }
        if (tokenTypeValue.startsWith("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512")) {
            return ConversationConstants.getWSTVersion((String)"http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512");
        }
        throw new ConversationException("unsupportedSecConvVersion");
    }
}

